/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.sources;

import io.reactivex.rxjava3.core.Observable;
import javafx.beans.property.SetProperty;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.pdfsam.rxjavafx.observables.JavaFxObservable;
import org.pdfsam.rxjavafx.sources.Flag;
import org.pdfsam.rxjavafx.sources.SetChange;
import org.pdfsam.rxjavafx.subscriptions.JavaFxSubscriptions;

public final class ObservableSetSource {
    private ObservableSetSource() {
    }

    public static <T> Observable<ObservableSet<T>> fromObservableSet(ObservableSet<T> source) {
        Observable mutations = Observable.create(subscriber -> {
            SetChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
        if (source instanceof SetProperty) {
            return JavaFxObservable.valuesOf((SetProperty)source);
        }
        return mutations.startWithArray((Object[])new ObservableSet[]{source});
    }

    public static <T> Observable<T> fromObservableSetAdds(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasAdded()) {
                    subscriber.onNext(c.getElementAdded());
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
    }

    public static <T> Observable<T> fromObservableSetRemovals(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(c.getElementRemoved());
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
    }

    public static <T> Observable<SetChange<T>> fromObservableSetChanges(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new SetChange<Object>(c.getElementRemoved(), Flag.REMOVED));
                }
                if (c.wasAdded()) {
                    subscriber.onNext(new SetChange<Object>(c.getElementAdded(), Flag.ADDED));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
    }
}

