/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.sources;

import io.reactivex.rxjava3.core.Observable;
import java.util.AbstractMap;
import java.util.Map;
import javafx.beans.property.MapProperty;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import org.pdfsam.rxjavafx.observables.JavaFxObservable;
import org.pdfsam.rxjavafx.sources.Flag;
import org.pdfsam.rxjavafx.sources.MapChange;
import org.pdfsam.rxjavafx.subscriptions.JavaFxSubscriptions;

public final class ObservableMapSource {
    private ObservableMapSource() {
    }

    public static <K, T> Observable<ObservableMap<K, T>> fromObservableMap(ObservableMap<K, T> source) {
        Observable mutations = Observable.create(subscriber -> {
            MapChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
        if (source instanceof MapProperty) {
            return JavaFxObservable.valuesOf((MapProperty)source);
        }
        return mutations.startWithArray((Object[])new ObservableMap[]{source});
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapAdds(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasAdded()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueAdded()));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapRemovals(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueRemoved()));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
    }

    public static <K, T> Observable<MapChange<K, T>> fromObservableMapChanges(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new MapChange<Object, Object>(c.getKey(), c.getValueRemoved(), Flag.REMOVED));
                }
                if (c.wasAdded()) {
                    subscriber.onNext(new MapChange<Object, Object>(c.getKey(), c.getValueAdded(), Flag.ADDED));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        });
    }
}

