/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.observers;

import java.util.Arrays;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public abstract class ObservableListenerHelper<T>
implements ObservableValue<T> {
    private boolean sentinel;
    private int invalidationSize = 0;
    private int size = 0;
    private Object listener = null;
    private T value = null;

    public void addListener(InvalidationListener listener) {
        Objects.requireNonNull(listener);
        if (this.size == 0) {
            this.sentinel = false;
            this.invalidationSize = 1;
            this.listener = listener;
        } else if (this.size == 1) {
            this.sentinel = false;
            if (this.invalidationSize == 1) {
                this.invalidationSize = 2;
                this.listener = new Object[]{this.listener, listener};
            } else {
                this.invalidationSize = 1;
                this.listener = new Object[]{listener, this.listener};
            }
        } else {
            Object[] l = (Object[])this.listener;
            if (l.length <= this.size + 1 || this.sentinel) {
                this.sentinel = false;
                this.listener = l = Arrays.copyOf(l, l.length * 3 / 2 + 1);
            }
            if (this.size > this.invalidationSize) {
                System.arraycopy(l, this.invalidationSize, l, this.invalidationSize + 1, this.size - this.invalidationSize);
            }
            l[this.invalidationSize] = listener;
            ++this.invalidationSize;
        }
        ++this.size;
    }

    public void removeListener(InvalidationListener listener) {
        block4: {
            block6: {
                Object[] l;
                block7: {
                    block5: {
                        Objects.requireNonNull(listener);
                        if (0 >= this.invalidationSize) break block4;
                        if (this.size != 1) break block5;
                        if (this.invalidationSize != 1 || !this.listener.equals(listener)) break block4;
                        this.sentinel = false;
                        this.listener = null;
                        --this.invalidationSize;
                        --this.size;
                        break block4;
                    }
                    if (this.size != 2) break block6;
                    l = (Object[])this.listener;
                    if (!listener.equals(l[0])) break block7;
                    this.sentinel = false;
                    --this.invalidationSize;
                    --this.size;
                    this.listener = l[1];
                    break block4;
                }
                if (this.invalidationSize != 2 || !listener.equals(l[1])) break block4;
                this.sentinel = false;
                --this.invalidationSize;
                --this.size;
                this.listener = l[0];
                break block4;
            }
            Object[] l = (Object[])this.listener;
            for (int i = 0; i < this.invalidationSize; ++i) {
                if (!listener.equals(l[i])) continue;
                if (this.sentinel) {
                    this.sentinel = false;
                    this.listener = l = Arrays.copyOf(l, l.length);
                }
                if (i + 1 < this.size) {
                    System.arraycopy(l, i + 1, l, i, this.size - i - 1);
                } else {
                    l[i] = null;
                }
                --this.invalidationSize;
                --this.size;
                break;
            }
        }
    }

    public void addListener(ChangeListener<? super T> listener) {
        Objects.requireNonNull(listener);
        if (this.size == 0) {
            this.sentinel = false;
            this.listener = listener;
            this.value = this.getValue();
        } else if (this.size == 1) {
            this.sentinel = false;
            this.listener = new Object[]{this.listener, listener};
        } else {
            Object[] l = (Object[])this.listener;
            if (l.length <= this.size + 1) {
                this.sentinel = false;
                this.listener = l = Arrays.copyOf(l, l.length * 3 / 2 + 1);
            }
            l[this.size] = listener;
        }
        if (this.invalidationSize == this.size) {
            this.value = this.getValue();
        }
        ++this.size;
    }

    public void removeListener(ChangeListener<? super T> listener) {
        block4: {
            block6: {
                Object[] l;
                block7: {
                    block5: {
                        Objects.requireNonNull(listener);
                        if (this.invalidationSize >= this.size) break block4;
                        if (this.size != 1) break block5;
                        this.sentinel = false;
                        --this.size;
                        this.listener = null;
                        this.value = null;
                        break block4;
                    }
                    if (this.size != 2) break block6;
                    l = (Object[])this.listener;
                    if (!listener.equals(l[1])) break block7;
                    this.sentinel = false;
                    --this.size;
                    this.listener = l[0];
                    if (this.invalidationSize != 1) break block4;
                    this.value = null;
                    break block4;
                }
                if (this.invalidationSize != 0 || !listener.equals(l[1])) break block4;
                this.sentinel = false;
                --this.size;
                this.listener = l[1];
                break block4;
            }
            Object[] l = (Object[])this.listener;
            for (int i = this.invalidationSize; i < this.size; ++i) {
                if (!listener.equals(l[i])) continue;
                if (this.sentinel) {
                    this.sentinel = false;
                    this.listener = l = Arrays.copyOf(l, l.length);
                }
                if (i + 1 < this.size) {
                    System.arraycopy(l, i + 1, l, i, this.size - i - 1);
                } else {
                    l[i] = null;
                }
                --this.size;
                if (this.size != this.invalidationSize) break;
                this.value = null;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChange() {
        Object listener = this.listener;
        int invalidationSize = this.invalidationSize;
        int size = this.size;
        try {
            this.sentinel = true;
            if (size == 1) {
                if (invalidationSize == 1) {
                    try {
                        ((InvalidationListener)listener).invalidated((Observable)this);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                } else {
                    T oldValue = this.value;
                    this.value = this.getValue();
                    try {
                        ((ChangeListener)listener).changed((ObservableValue)this, oldValue, this.value);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            } else if (size > 0) {
                Object[] l = (Object[])listener;
                for (int i = 0; i < invalidationSize; ++i) {
                    try {
                        ((InvalidationListener)l[i]).invalidated((Observable)this);
                        continue;
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
                if (invalidationSize < size) {
                    T oldValue = this.value;
                    this.value = this.getValue();
                    for (int i = invalidationSize; i < size; ++i) {
                        try {
                            ((ChangeListener)l[i]).changed((ObservableValue)this, oldValue, this.value);
                            continue;
                        }
                        catch (Exception e) {
                            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                        }
                    }
                }
            }
        }
        finally {
            this.sentinel = false;
        }
    }
}

