/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.observers;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.flowables.ConnectableFlowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Optional;
import javafx.beans.binding.Binding;
import org.pdfsam.rxjavafx.observers.BindingSubscriber;

public enum JavaFxSubscriber {


    public static <T> Binding<T> toBinding(Flowable<T> flowable) {
        return JavaFxSubscriber.toBinding(flowable, (Consumer<Throwable>)((Consumer)JavaFxSubscriber::onError));
    }

    public static <T> Binding<T> toBinding(Flowable<T> flowable, Consumer<Throwable> onErrorAction) {
        BindingSubscriber bindingSubscriber = new BindingSubscriber(t -> t, onErrorAction);
        flowable.subscribe(bindingSubscriber);
        return bindingSubscriber;
    }

    public static <T> Binding<T> toNullBinding(Flowable<T> flowable, T nullSentinel) {
        return JavaFxSubscriber.toNullBinding(flowable, nullSentinel, (Consumer<Throwable>)((Consumer)JavaFxSubscriber::onError));
    }

    public static <T> Binding<T> toNullBinding(Flowable<T> flowable, T nullSentinel, Consumer<Throwable> onErrorAction) {
        if (nullSentinel == null) {
            throw new NullPointerException("The null value sentinel must not be null.");
        }
        BindingSubscriber bindingSubscriber = new BindingSubscriber(t -> t == nullSentinel ? null : t, onErrorAction);
        flowable.subscribe(bindingSubscriber);
        return bindingSubscriber;
    }

    public static <T> Binding<T> toNullableBinding(Flowable<Optional<T>> flowable) {
        return JavaFxSubscriber.toNullableBinding(flowable, (Consumer<Throwable>)((Consumer)JavaFxSubscriber::onError));
    }

    public static <T> Binding<T> toNullableBinding(Flowable<Optional<T>> flowable, Consumer<Throwable> onErrorAction) {
        BindingSubscriber bindingSubscriber = new BindingSubscriber(o -> o.orElse(null), onErrorAction);
        flowable.subscribe(bindingSubscriber);
        return bindingSubscriber;
    }

    public static <T> Binding<T> toLazyBinding(Flowable<T> flowable) {
        return JavaFxSubscriber.toLazyBinding(flowable, (Consumer<Throwable>)((Consumer)JavaFxSubscriber::onError));
    }

    public static <T> Binding<T> toLazyBinding(Flowable<T> flowable, Consumer<Throwable> onErrorAction) {
        ConnectableFlowable published = flowable.publish();
        BindingSubscriber bindingSubscriber = new BindingSubscriber(t -> t, published, onErrorAction);
        published.subscribe(bindingSubscriber);
        return bindingSubscriber;
    }

    public static <T> Binding<T> toLazyNullBinding(Flowable<T> flowable, T nullSentinel) {
        return JavaFxSubscriber.toLazyNullBinding(flowable, nullSentinel, (Consumer<Throwable>)((Consumer)JavaFxSubscriber::onError));
    }

    public static <T> Binding<T> toLazyNullBinding(Flowable<T> flowable, T nullSentinel, Consumer<Throwable> onErrorAction) {
        if (nullSentinel == null) {
            throw new NullPointerException("The null value sentinel must not be null.");
        }
        ConnectableFlowable published = flowable.publish();
        BindingSubscriber bindingSubscriber = new BindingSubscriber(t -> t == nullSentinel ? null : t, published, onErrorAction);
        published.subscribe(bindingSubscriber);
        return bindingSubscriber;
    }

    public static <T> Binding<T> toLazyNullableBinding(Flowable<Optional<T>> flowable) {
        return JavaFxSubscriber.toLazyNullableBinding(flowable, (Consumer<Throwable>)((Consumer)JavaFxSubscriber::onError));
    }

    public static <T> Binding<T> toLazyNullableBinding(Flowable<Optional<T>> flowable, Consumer<Throwable> onErrorAction) {
        ConnectableFlowable published = flowable.publish();
        BindingSubscriber bindingSubscriber = new BindingSubscriber(o -> o.orElse(null), published, onErrorAction);
        published.subscribe(bindingSubscriber);
        return bindingSubscriber;
    }

    private static void onError(Throwable t) {
        RxJavaPlugins.onError((Throwable)t);
    }
}

