/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.observers;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.observables.ConnectableObservable;
import javafx.beans.binding.Binding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.pdfsam.rxjavafx.observers.ObservableListenerHelper;

final class BindingObserver<T, S>
extends ObservableListenerHelper<S>
implements Observer<T>,
ObservableValue<S>,
Binding<S> {
    private final Function<T, S> unmaskingFunction;
    private final Consumer<Throwable> onError;
    private final ConnectableObservable<T> obs;
    private boolean connected = false;
    private Disposable disposable;
    private S value;

    BindingObserver(Function<T, S> unmaskingFunction, Consumer<Throwable> onError) {
        this.unmaskingFunction = unmaskingFunction;
        this.onError = onError;
        this.obs = null;
    }

    BindingObserver(Function<T, S> unmaskingFunction, ConnectableObservable<T> obs, Consumer<Throwable> onError) {
        this.unmaskingFunction = unmaskingFunction;
        this.onError = onError;
        this.obs = obs;
    }

    public void onSubscribe(Disposable d) {
        this.disposable = d;
    }

    public void onComplete() {
    }

    public void onError(Throwable e) {
        try {
            this.onError.accept((Object)e);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
    }

    public void onNext(T t) {
        try {
            this.value = this.unmaskingFunction.apply(t);
            this.fireChange();
        }
        catch (Throwable e) {
            this.onError(e);
        }
    }

    public S getValue() {
        if (!this.connected && this.obs != null) {
            this.obs.connect();
            this.connected = true;
        }
        return this.value;
    }

    public boolean isValid() {
        return true;
    }

    public void invalidate() {
    }

    public ObservableList<?> getDependencies() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }
}

