/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.rule;

import java.io.IOException;
import java.util.Map;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;
import org.pageseeder.smith.function.LinearScore;
import org.pageseeder.smith.function.ScoreArray;

public final class DigitCountRule
implements PasswordRule,
Scriptable {
    private ScoreFunction _function = LinearScore.IDENTITY;

    @Override
    public int score(String password) {
        if (password == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < password.length(); ++i) {
            if (password.charAt(i) < '0' || password.charAt(i) > '9') continue;
            ++count;
        }
        return this._function.get(count);
    }

    @Override
    public void configure(Map<String, String> config) {
        this._function = ScoreArray.parse(config);
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (p) {");
        script.append(" var f = ");
        this._function.toScript(script).append(";");
        script.append(" var n = p && (p.length - p.replace(/[0-9]/g, '').length) || 0;");
        script.append(" return f(n);");
        script.append("}");
        return script;
    }
}

