/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.OutputOptions;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.ValidationException;
import org.pageseeder.schematron.svrl.SVRLByteArray;
import org.pageseeder.schematron.svrl.SVRLDataFile;
import org.pageseeder.schematron.svrl.SVRLStreamWriter;
import org.pageseeder.schematron.svrl.SVRLString;

public final class Validator {
    private static final ErrorListener QUIET_LISTENER = new ErrorListener(){

        @Override
        public void warning(TransformerException ex) {
        }

        @Override
        public void error(TransformerException ex) {
        }

        @Override
        public void fatalError(TransformerException ex) {
        }
    };
    private final Templates _validator;
    private final OutputOptions _options;
    private final URIResolver _resolver;

    Validator(Templates templates) {
        this(templates, OutputOptions.defaults(), null);
    }

    private Validator(Templates templates, OutputOptions options, URIResolver resolver) {
        if (templates == null) {
            throw new NullPointerException("A validator cannot be constructed with null templates");
        }
        this._validator = templates;
        this._options = Objects.requireNonNull(options);
        this._resolver = resolver;
    }

    public Validator options(OutputOptions options) {
        return new Validator(this._validator, options, this._resolver);
    }

    public OutputOptions options() {
        return this._options;
    }

    public Validator resolver(URIResolver resolver) {
        return new Validator(this._validator, this._options, resolver);
    }

    public SchematronResult validate(File xml) throws SchematronException {
        return this.validate(new StreamSource(xml), Collections.emptyMap());
    }

    public SchematronResult validate(Source xml) throws SchematronException {
        return this.validate(xml, Collections.emptyMap());
    }

    public SchematronResult validate(File xml, Map<String, Object> parameters) throws SchematronException {
        return this.validate(new StreamSource(xml), parameters);
    }

    public SchematronResult validate(Source xml, Map<String, Object> parameters) throws SchematronException {
        return this.newInstance().validate(xml, parameters);
    }

    public Instance newInstance() throws SchematronException {
        Transformer transformer = Validator.newTransformer(this._validator, this._options, this._resolver);
        return new Instance(transformer, this._options);
    }

    private static Transformer newTransformer(Templates validator, OutputOptions options, URIResolver resolver) throws SchematronException {
        Transformer transformer;
        try {
            transformer = validator.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new SchematronException("Unable to create new validator", ex);
        }
        transformer.setOutputProperty("encoding", options.encoding());
        transformer.setOutputProperty("indent", options.isIndent() ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", options.isOmitXmlDeclaration() ? "yes" : "no");
        if (resolver != null) {
            transformer.setURIResolver(resolver);
        }
        return transformer;
    }

    public static class Instance {
        private final Transformer _transformer;
        private final OutputOptions _options;
        private volatile boolean validating = false;

        private Instance(Transformer transformer, OutputOptions options) {
            this._transformer = transformer;
            this._options = options;
        }

        public SchematronResult validate(File xml) throws SchematronException {
            return this.validate(new StreamSource(xml));
        }

        public SchematronResult validate(Source xml) throws SchematronException {
            return this.validate(xml, null);
        }

        public SchematronResult validate(File xml, Map<String, Object> parameters) throws SchematronException {
            return this.validate(new StreamSource(xml), parameters);
        }

        public SchematronResult validate(Source xml, Map<String, Object> parameters) throws SchematronException {
            StringWriter writer = new StringWriter();
            SchematronResult.Builder result = this.transform(xml, parameters, writer);
            result.setSVRL(new SVRLString(writer.toString()));
            return result.build();
        }

        public SchematronResult validateToBytes(Source xml, Map<String, Object> parameters) throws SchematronException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Charset charset = Charset.forName(this._options.encoding());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
            SchematronResult.Builder result = this.transform(xml, parameters, writer);
            result.setSVRL(new SVRLByteArray(out.toByteArray(), charset));
            return result.build();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SchematronResult validateToFile(Source xml, Map<String, Object> parameters, File file) throws SchematronException {
            try (FileOutputStream out = new FileOutputStream(file);){
                Charset charset = Charset.forName(this._options.encoding());
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
                SchematronResult.Builder result = this.transform(xml, parameters, writer);
                result.setSVRL(new SVRLDataFile(file, charset));
                SchematronResult schematronResult = result.build();
                return schematronResult;
            }
            catch (IOException ex) {
                throw new SchematronException(ex);
            }
        }

        private SchematronResult.Builder transform(Source xml, Map<String, Object> parameters, Writer writer) throws SchematronException {
            if (this.validating) {
                throw new IllegalStateException("Unable to validate multiple source concurrently");
            }
            this.validating = true;
            SchematronResult.Builder result = new SchematronResult.Builder();
            result.setSystemID(xml.getSystemId());
            try {
                if (parameters != null && parameters.size() > 0) {
                    for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                        this._transformer.setParameter(parameter.getKey(), parameter.getValue());
                    }
                }
                this._transformer.setErrorListener(QUIET_LISTENER);
                SVRLStreamWriter svrl = new SVRLStreamWriter(writer, this._options);
                this._transformer.transform(xml, new StAXResult(svrl));
                result.setAssertsCount(svrl.getAssertsCount());
                result.setReportsCount(svrl.getReportsCount());
            }
            catch (TransformerException ex) {
                throw new ValidationException(ex);
            }
            catch (XMLStreamException ex) {
                throw new SchematronException("Unable to process SVRL results", ex);
            }
            finally {
                this.validating = false;
            }
            return result;
        }
    }
}

