/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.svrl.AssertOrReport;
import org.pageseeder.schematron.svrl.SVRLData;
import org.pageseeder.schematron.svrl.SVRLParser;
import org.pageseeder.schematron.svrl.SVRLString;
import org.pageseeder.schematron.svrl.SchematronOutput;

public final class SchematronResult
implements Serializable {
    private final String systemID;
    private SVRLData svrl;
    private int assertsCount = -1;
    private int reportsCount = -1;

    public SchematronResult(String systemID) {
        this.systemID = systemID;
    }

    public SchematronResult(String systemID, SVRLData svrl, int assertsCount, int reportsCount) {
        this.systemID = systemID;
        this.svrl = svrl;
        this.assertsCount = assertsCount;
        this.reportsCount = reportsCount;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public boolean isValid() {
        return this.assertsCount == 0;
    }

    public boolean hasAsserts() {
        return this.assertsCount > 0;
    }

    public boolean hasReports() {
        return this.reportsCount > 0;
    }

    @Deprecated
    public void setSVRL(String svrl, int assertsCount, int reportsCount) {
        this.svrl = new SVRLString(svrl);
        this.assertsCount = assertsCount;
        this.reportsCount = reportsCount;
    }

    public SchematronOutput toSchematronOutput() throws SchematronException {
        try {
            return SVRLParser.parse(this.svrl.getReader());
        }
        catch (IOException ex) {
            throw new SchematronException(ex);
        }
    }

    public String getSVRLAsString() {
        return this.svrl.asString();
    }

    public byte[] getSVRLAsBytes() {
        return this.svrl.asByteArray();
    }

    public Reader getSVRLReader() throws IOException {
        return this.svrl.getReader();
    }

    public String getFailedMessage() {
        StringBuilder out = new StringBuilder();
        if (this.assertsCount > 0) {
            SchematronOutput output = this.toSchematronOutputSilently();
            for (AssertOrReport failedAssertion : output.getFailedAsserts()) {
                out.append(failedAssertion.toMessageString());
            }
        }
        return out.toString();
    }

    private SchematronOutput toSchematronOutputSilently() {
        try {
            return SVRLParser.parse(this.svrl.getReader());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (SchematronException ex) {
            throw new IllegalStateException("Invalid SVRL content", ex);
        }
    }

    static class Builder {
        private String systemID;
        private SVRLData svrl;
        private int assertsCount = -1;
        private int reportsCount = -1;

        Builder() {
        }

        public Builder setSystemID(String systemID) {
            this.systemID = systemID;
            return this;
        }

        public Builder setSVRL(SVRLData svrl) {
            this.svrl = svrl;
            return this;
        }

        public Builder setAssertsCount(int assertsCount) {
            this.assertsCount = assertsCount;
            return this;
        }

        public Builder setReportsCount(int reportsCount) {
            this.reportsCount = reportsCount;
            return this;
        }

        public SchematronResult build() {
            return new SchematronResult(this.systemID, this.svrl, this.assertsCount, this.reportsCount);
        }
    }
}

