/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import org.pageseeder.schematron.svrl.AssertOrReport;

public final class SVRL {
    public static final String NAMESPACE_URI = "http://purl.oclc.org/dsdl/svrl";

    public static List<String> toMessageList(List<AssertOrReport> assertOrReports) {
        return assertOrReports.stream().map(AssertOrReport::toMessageString).collect(Collectors.toList());
    }

    public static List<String> toMessageList(List<AssertOrReport> assertOrReports, boolean includeDiagnostics) {
        return assertOrReports.stream().map(a -> a.toMessageString(includeDiagnostics)).collect(Collectors.toList());
    }

    public static String toLocationPrefix(String location, NamespaceContext context) {
        Pattern p = Pattern.compile("Q\\{([^}]*)}");
        Matcher m = p.matcher(location);
        StringBuffer update = new StringBuffer();
        while (m.find()) {
            String namespaceURI = m.group(1);
            String prefix = context.getPrefix(namespaceURI);
            if (prefix == null) {
                if (namespaceURI.isEmpty() && context.getNamespaceURI("") == null) {
                    m.appendReplacement(update, "");
                    continue;
                }
                m.appendReplacement(update, m.group());
                continue;
            }
            m.appendReplacement(update, prefix + ":");
        }
        m.appendTail(update);
        return update.toString();
    }
}

