/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.CompileOptions;
import org.pageseeder.schematron.Compiler;
import org.pageseeder.schematron.DebugOutput;
import org.pageseeder.schematron.Precompiler;
import org.pageseeder.schematron.QueryBinding;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.Validator;
import org.w3c.dom.Document;

public final class ValidatorFactory {
    private static final DebugOutput NO_DEBUG = systemId -> null;
    private static final DebugOutput BASIC_DEBUG = systemId -> {
        String filename = "debug." + ValidatorFactory.removePathExtension(systemId) + ".xsl";
        return new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8);
    };
    private final TransformerFactory _factory;
    private final Class<URIResolver> _resolver;
    private final ErrorListener _listener;
    private final DebugOutput _debug;
    private final CompileOptions _options;
    private static volatile Precompiler precompiler1 = null;
    private static volatile Precompiler precompiler2 = null;

    public ValidatorFactory() {
        this(CompileOptions.defaults());
    }

    public ValidatorFactory(CompileOptions options) {
        this._factory = TransformerFactory.newInstance();
        this._options = Objects.requireNonNull(options);
        this._listener = this._factory.getErrorListener();
        this._resolver = null;
        this._debug = NO_DEBUG;
    }

    private ValidatorFactory(TransformerFactory factory, CompileOptions options, ErrorListener listener, Class<URIResolver> resolver, DebugOutput debug) {
        this._factory = factory;
        this._options = Objects.requireNonNull(options);
        this._listener = Objects.requireNonNull(listener);
        this._resolver = resolver;
        this._debug = debug;
    }

    public ValidatorFactory options(CompileOptions options) {
        return new ValidatorFactory(this._factory, options, this._listener, this._resolver, this._debug);
    }

    @Deprecated
    public CompileOptions getOptions() {
        return this._options;
    }

    public CompileOptions options() {
        return this._options;
    }

    public ValidatorFactory errorListener(ErrorListener listener) {
        return new ValidatorFactory(this._factory, this._options, listener, this._resolver, this._debug);
    }

    public ErrorListener getErrorListener() {
        return this._listener;
    }

    public ValidatorFactory enableDebug() {
        if (this._debug != null && this._debug != NO_DEBUG) {
            return this;
        }
        return new ValidatorFactory(this._factory, this._options, this._listener, this._resolver, BASIC_DEBUG);
    }

    public ValidatorFactory disableDebug() {
        if (this._debug == null || this._debug == NO_DEBUG) {
            return this;
        }
        return new ValidatorFactory(this._factory, this._options, this._listener, this._resolver, NO_DEBUG);
    }

    public ValidatorFactory debug(DebugOutput debug) {
        return new ValidatorFactory(this._factory, this._options, this._listener, this._resolver, debug);
    }

    public ValidatorFactory resolver(Class<URIResolver> resolver) {
        return new ValidatorFactory(this._factory, this._options, this._listener, resolver, this._debug);
    }

    public Validator newValidator(File schema) throws SchematronException {
        if (!schema.exists()) {
            throw new SchematronException("Unable to find schema", new FileNotFoundException(schema.getPath()));
        }
        StreamSource source = new StreamSource(schema);
        return this.newValidator(source);
    }

    public Validator newValidator(File schema, String phase) throws SchematronException {
        if (!schema.exists()) {
            throw new SchematronException("Unable to find schema", new FileNotFoundException(schema.getPath()));
        }
        StreamSource source = new StreamSource(schema);
        return this.newValidator(source, phase);
    }

    public Validator newValidator(Source schema) throws SchematronException {
        return this.newValidator(schema, null);
    }

    public Validator newValidator(Source schema, String phase) throws SchematronException {
        Templates validator;
        Document schematron = this.loadSchema(schema);
        String systemId = schematron.getDocumentURI();
        QueryBinding binding = this.getQueryBinding(schematron, this._options);
        Precompiler precompiler = this.getPrecompiler(binding);
        Compiler compiler = precompiler.prepare(this._listener, this._options.toParameters(phase));
        DOMSource schemaSource = new DOMSource(schematron, systemId);
        Document stylesheet = compiler.compile(schemaSource);
        stylesheet.setDocumentURI(systemId);
        if (this._debug != null) {
            try {
                Writer writer = this._debug.getWriter(systemId);
                if (writer != null) {
                    StreamResult result = new StreamResult(writer);
                    Transformer transformer = this._factory.newTransformer();
                    transformer.setOutputProperty("indent", this._debug.indent() ? "yes" : "no");
                    transformer.transform(new DOMSource(stylesheet), result);
                }
            }
            catch (IOException | TransformerException ex) {
                throw new SchematronException("Unable to save debug output", ex);
            }
        }
        if (this._resolver != null) {
            try {
                this._factory.setURIResolver(this._resolver.newInstance());
            }
            catch (Throwable t) {
                throw new SchematronException("Unable to instantiate new resolver", t);
            }
        }
        try {
            validator = this._factory.newTemplates(new DOMSource(stylesheet));
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to generate new Validator from preprocessed " + schema.getSystemId(), ex);
        }
        return new Validator(validator);
    }

    private Document loadSchema(Source source) throws SchematronException {
        String systemId = source.getSystemId();
        try {
            DOMResult schema = new DOMResult();
            this._factory.newTransformer().transform(source, schema);
            Document schemaDocument = (Document)schema.getNode();
            schemaDocument.setDocumentURI(systemId);
            return schemaDocument;
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to parse source schema", ex);
        }
    }

    private QueryBinding getQueryBinding(Document schematron, CompileOptions options) throws SchematronException {
        String queryBinding = schematron.getDocumentElement().getAttribute("queryBinding").toLowerCase();
        if ("".equals(queryBinding)) {
            queryBinding = options.defaultQueryBinding();
            schematron.getDocumentElement().setAttribute("queryBinding", queryBinding);
        }
        return QueryBinding.forValue(queryBinding);
    }

    private Precompiler getPrecompiler(QueryBinding binding) throws SchematronException {
        if ("1.0".equals(binding.version()) && precompiler1 != null) {
            return precompiler1;
        }
        if ("2.0".equals(binding.version()) && precompiler2 != null) {
            return precompiler2;
        }
        Precompiler precompiler = Precompiler.create(this._factory, binding);
        if ("1.0".equals(binding.version())) {
            precompiler1 = precompiler;
        } else if ("2.0".equals(binding.version())) {
            precompiler2 = precompiler;
        }
        return precompiler;
    }

    private static String removePathExtension(String filepath) {
        String[] split = filepath.split("[/\\\\]");
        return split[split.length - 1].replaceAll(".sch$", "");
    }
}

