/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.Compiler;
import org.pageseeder.schematron.QueryBinding;
import org.pageseeder.schematron.SchematronException;

final class Precompiler {
    private static final List<String> STEPS = Arrays.asList("include.xsl", "expand.xsl", "compile-for-svrl.xsl");
    private final String _xsltVersion;
    private final List<Templates> _pipeline;

    private Precompiler(String version, List<Templates> templates) {
        this._xsltVersion = version;
        this._pipeline = templates;
    }

    public String getXsltVersion() {
        return this._xsltVersion;
    }

    public static Precompiler create(TransformerFactory transformerFactory, QueryBinding binding) throws SchematronException {
        ArrayList<Templates> pipeline = new ArrayList<Templates>(3);
        try {
            for (String step : STEPS) {
                String path = "xslt/" + binding.version() + "/" + step;
                URL url = Precompiler.class.getResource(path);
                if (url == null) {
                    throw new IllegalArgumentException("Preprocessor '" + path + "' cannot be found in the classpath.");
                }
                StreamSource source = new StreamSource(url.toString());
                Templates templates = transformerFactory.newTemplates(source);
                pipeline.add(templates);
            }
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to precompile transformation stylesheets", ex);
        }
        return new Precompiler(binding.version(), pipeline);
    }

    public Compiler prepare(ErrorListener listener, Map<String, Object> parameters) throws SchematronException {
        ArrayList<Transformer> transformers = new ArrayList<Transformer>(3);
        try {
            for (Templates templates : this._pipeline) {
                Transformer transformer = templates.newTransformer();
                transformer.setErrorListener(listener);
                if (!parameters.isEmpty()) {
                    for (Map.Entry<String, Object> p : parameters.entrySet()) {
                        String name = p.getKey();
                        transformer.setParameter(name, p.getValue());
                    }
                }
                transformers.add(transformer);
            }
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to compile Schematron to transformation stylesheet", ex);
        }
        return new Compiler(transformers);
    }
}

