/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.pageseeder.schematron.SchematronException;
import org.w3c.dom.Document;

final class Compiler {
    private final List<Transformer> _transformers;

    Compiler(List<Transformer> transformers) {
        this._transformers = transformers;
    }

    public Document compile(Source document) throws SchematronException {
        try {
            DOMResult result = null;
            Source source = document;
            for (Transformer transformer : this._transformers) {
                result = new DOMResult();
                transformer.transform(source, result);
                source = new DOMSource(result.getNode(), source.getSystemId());
            }
            return (Document)result.getNode();
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to compile Schematron to transformation stylesheet", ex);
        }
    }
}

