/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.svrl.SVRLEventHandler;
import org.pageseeder.schematron.svrl.SchematronOutput;

public final class SVRLParser {
    private SVRLParser() {
    }

    public static SchematronOutput parse(File svrl) throws SchematronException, IOException {
        try (FileReader reader = new FileReader(svrl);){
            SchematronOutput schematronOutput = SVRLParser.parse(reader);
            return schematronOutput;
        }
    }

    public static SchematronOutput parse(Reader svrl) throws SchematronException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            XMLEventReader eventReader = factory.createXMLEventReader(svrl);
            SVRLEventHandler handler = new SVRLEventHandler();
            return handler.parse(eventReader);
        }
        catch (XMLStreamException ex) {
            throw new SchematronException("Unable to parse SVRL", ex);
        }
    }
}

