/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.Serializable;
import java.io.StringReader;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.svrl.AssertOrReport;
import org.pageseeder.schematron.svrl.SVRLParser;
import org.pageseeder.schematron.svrl.SchematronOutput;

public final class SchematronResult
implements Serializable {
    private final String systemID;
    private String svrl;
    private int assertsCount = -1;
    private int reportsCount = -1;

    public SchematronResult(String systemID) {
        this.systemID = systemID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public boolean isValid() {
        return this.assertsCount == 0;
    }

    public boolean hasAsserts() {
        return this.assertsCount > 0;
    }

    public boolean hasReports() {
        return this.reportsCount > 0;
    }

    public void setSVRL(String svrl, int assertsCount, int reportsCount) {
        this.svrl = svrl;
        this.assertsCount = assertsCount;
        this.reportsCount = reportsCount;
    }

    public SchematronOutput toSchematronOutput() throws SchematronException {
        return SVRLParser.parse(new StringReader(this.svrl));
    }

    public String getSVRLAsString() {
        return this.svrl;
    }

    public String getFailedMessage() {
        StringBuilder out = new StringBuilder();
        if (this.assertsCount > 0) {
            SchematronOutput output = this.toSchematronOutputSilently();
            for (AssertOrReport failedAssertion : output.getFailedAsserts()) {
                out.append(failedAssertion.toMessageString());
            }
        }
        return out.toString();
    }

    private SchematronOutput toSchematronOutputSilently() {
        try {
            return SVRLParser.parse(new StringReader(this.svrl));
        }
        catch (SchematronException ex) {
            throw new IllegalStateException("Invalid SVRL content", ex);
        }
    }
}

