/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.CompileOptions;
import org.pageseeder.schematron.Compiler;
import org.pageseeder.schematron.Precompiler;
import org.pageseeder.schematron.QueryBinding;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.Validator;
import org.w3c.dom.Document;

public final class ValidatorFactory {
    private final TransformerFactory _factory = TransformerFactory.newInstance();
    private Class<URIResolver> _resolver;
    private ErrorListener _listener = this._factory.getErrorListener();
    private boolean debugMode = false;
    private CompileOptions options = CompileOptions.defaults();
    private static volatile Precompiler precompiler1 = null;
    private static volatile Precompiler precompiler2 = null;

    public void setOptions(CompileOptions options) {
        this.options = options != null ? options : CompileOptions.defaults();
    }

    public CompileOptions getOptions() {
        return this.options;
    }

    public void setErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("The error listener must not be null.");
        }
        this._listener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._listener;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setResolver(Class<URIResolver> resolver) {
        this._resolver = resolver;
    }

    public Validator newValidator(File schema) throws SchematronException {
        if (!schema.exists()) {
            throw new SchematronException("Unable to find schema", new FileNotFoundException(schema.getPath()));
        }
        StreamSource source = new StreamSource(schema);
        return this.newValidator(source);
    }

    public Validator newValidator(File schema, String phase) throws SchematronException {
        if (!schema.exists()) {
            throw new SchematronException("Unable to find schema", new FileNotFoundException(schema.getPath()));
        }
        StreamSource source = new StreamSource(schema);
        return this.newValidator(source, phase);
    }

    public Validator newValidator(Source schema) throws SchematronException {
        return this.newValidator(schema, null);
    }

    public Validator newValidator(Source schema, String phase) throws SchematronException {
        Templates validator;
        Document schematron = this.loadSchema(schema);
        String systemId = schematron.getDocumentURI();
        QueryBinding binding = this.getQueryBinding(schematron, this.options);
        Precompiler precompiler = this.getPrecompiler(binding);
        DOMSource schemaSource = new DOMSource(schematron, systemId);
        Compiler compiler = precompiler.prepare(this._listener, this.options.toParameters(phase));
        Document stylesheet = compiler.compile(schemaSource);
        stylesheet.setDocumentURI(systemId);
        if (this.debugMode) {
            try {
                FileWriter writer = new FileWriter("debug.xslt");
                StreamResult result = new StreamResult(writer);
                Transformer transformer = this._factory.newTransformer();
                transformer.transform(new DOMSource(stylesheet), result);
            }
            catch (IOException | TransformerException ex) {
                throw new SchematronException("Unable to save debug.xslt", ex);
            }
        }
        if (this._resolver != null) {
            try {
                this._factory.setURIResolver(this._resolver.newInstance());
            }
            catch (Throwable t) {
                throw new SchematronException("Unable to instantiate new resolver", t);
            }
        }
        try {
            validator = this._factory.newTemplates(new DOMSource(stylesheet));
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to generate new Validator from preprocessed " + schema.getSystemId(), ex);
        }
        return new Validator(validator);
    }

    private Document loadSchema(Source source) throws SchematronException {
        String systemId = source.getSystemId();
        try {
            DOMResult schema = new DOMResult();
            this._factory.newTransformer().transform(source, schema);
            Document schemaDocument = (Document)schema.getNode();
            schemaDocument.setDocumentURI(systemId);
            return schemaDocument;
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to parse source schema", ex);
        }
    }

    private QueryBinding getQueryBinding(Document schematron, CompileOptions options) throws SchematronException {
        String queryBinding = schematron.getDocumentElement().getAttribute("queryBinding").toLowerCase();
        if ("".equals(queryBinding)) {
            queryBinding = options.defaultQueryBinding();
            schematron.getDocumentElement().setAttribute("queryBinding", queryBinding);
        }
        return QueryBinding.forValue(queryBinding);
    }

    private Precompiler getPrecompiler(QueryBinding binding) throws SchematronException {
        if ("1.0".equals(binding.version()) && precompiler1 != null) {
            return precompiler1;
        }
        if ("2.0".equals(binding.version()) && precompiler2 != null) {
            return precompiler2;
        }
        Precompiler precompiler = Precompiler.create(this._factory, binding);
        if ("1.0".equals(binding.version())) {
            precompiler1 = precompiler;
        } else if ("2.0".equals(binding.version())) {
            precompiler2 = precompiler;
        }
        return precompiler;
    }
}

