/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.OutputOptions;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.svrl.SVRLStreamWriter;

public final class Validator {
    private final Templates _validator;
    private URIResolver _resolver;

    Validator(Templates templates) {
        if (templates == null) {
            throw new NullPointerException("A validator cannot be constructed with null templates");
        }
        this._validator = templates;
        this._resolver = null;
    }

    public void setResolver(URIResolver resolver) {
        this._resolver = resolver;
    }

    public SchematronResult validate(File xml) throws SchematronException {
        return this.validate(new StreamSource(xml));
    }

    public SchematronResult validate(File xml, OutputOptions options) throws SchematronException {
        return this.validate(new StreamSource(xml), options);
    }

    public SchematronResult validate(Source xml) throws SchematronException {
        return this.validate(xml, OutputOptions.defaults(), this._resolver);
    }

    public SchematronResult validate(Source xml, OutputOptions options) throws SchematronException {
        return this.validate(xml, options, this._resolver);
    }

    public SchematronResult validate(Source xml, OutputOptions options, URIResolver resolver) throws SchematronException {
        Transformer transformer = Validator.newTransformer(this._validator, options, resolver);
        StringWriter writer = new StringWriter();
        SchematronResult result = new SchematronResult(xml.getSystemId());
        try {
            SVRLStreamWriter svrl = new SVRLStreamWriter(writer, options);
            transformer.transform(xml, new StAXResult(svrl));
            result.setSVRL(writer.toString(), svrl.getAssertsCount(), svrl.getReportsCount());
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to process file with schematron", ex);
        }
        catch (XMLStreamException ex) {
            throw new SchematronException("Unable to process SVRL results", ex);
        }
        return result;
    }

    private static Transformer newTransformer(Templates validator, OutputOptions options, URIResolver resolver) throws SchematronException {
        Transformer transformer;
        try {
            transformer = validator.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new SchematronException("Unable to create new validator", ex);
        }
        transformer.setOutputProperty("encoding", options.encoding());
        transformer.setOutputProperty("indent", options.isIndent() ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", options.isOmitXmlDeclaration() ? "yes" : "no");
        if (resolver != null) {
            transformer.setURIResolver(resolver);
        }
        return transformer;
    }
}

