/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.PrintStream;
import java.io.StringReader;
import java.util.List;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.svrl.AssertOrReport;
import org.pageseeder.schematron.svrl.SVRL;
import org.pageseeder.schematron.svrl.SVRLParser;
import org.pageseeder.schematron.svrl.SchematronOutput;

public final class SchematronResult {
    private final String systemID;
    private String svrl;
    private int assertsCount = -1;
    private int reportsCount = -1;

    public SchematronResult(String systemID) {
        this.systemID = systemID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public boolean isValid() {
        return this.assertsCount == 0;
    }

    public boolean hasAsserts() {
        return this.assertsCount > 0;
    }

    public boolean hasReports() {
        return this.reportsCount > 0;
    }

    public void setSVRL(String svrl, int assertsCount, int reportsCount) {
        this.svrl = svrl;
        this.assertsCount = assertsCount;
        this.reportsCount = reportsCount;
    }

    @Deprecated
    public void setSVRL(String svrl) {
        this.svrl = this.removeXMLheader(svrl);
    }

    public SchematronOutput toSchematronOutput() throws SchematronException {
        return SVRLParser.parse(new StringReader(this.svrl));
    }

    public String getSVRLAsString() {
        return this.svrl;
    }

    @Deprecated
    public void printFailedMessage(PrintStream out) {
        if (this.assertsCount > 0) {
            SchematronOutput output = this.toSchematronOutputSilently();
            out.println("Source file: " + this.removePath(this.systemID));
            for (AssertOrReport failedAssertion : output.getFailedAsserts()) {
                out.println(failedAssertion.toMessageString());
            }
        }
    }

    public String getFailedMessage() {
        StringBuilder out = new StringBuilder();
        if (this.assertsCount > 0) {
            SchematronOutput output = this.toSchematronOutputSilently();
            for (AssertOrReport failedAssertion : output.getFailedAsserts()) {
                out.append(failedAssertion.toMessageString());
            }
        }
        return out.toString();
    }

    @Deprecated
    public void printAllMessage(PrintStream out) {
        if (this.assertsCount > 0 || this.reportsCount > 0) {
            if (this.systemID != null) {
                out.println("Source file: " + this.removePath(this.systemID));
            }
            SchematronOutput output = this.toSchematronOutputSilently();
            for (AssertOrReport assertion : output.getAllAssertsOrReports()) {
                out.println(assertion.toMessageString());
            }
        }
    }

    @Deprecated
    public List<String> getFailedAssertions() {
        SchematronOutput output = this.toSchematronOutputSilently();
        return SVRL.toMessageList(output.getFailedAsserts());
    }

    @Deprecated
    public List<String> getSuccessfulReports() {
        SchematronOutput output = this.toSchematronOutputSilently();
        return SVRL.toMessageList(output.getSuccessfulReports());
    }

    private SchematronOutput toSchematronOutputSilently() {
        try {
            return SVRLParser.parse(new StringReader(this.svrl));
        }
        catch (SchematronException ex) {
            throw new IllegalStateException("Invalid SVRL content", ex);
        }
    }

    private String removeXMLheader(String svrl) {
        int firstLineEnd = svrl.indexOf("\n");
        if (svrl.startsWith("<?xml ") || svrl.startsWith("<?xml ", 1) || svrl.startsWith("<?xml ", 2) || svrl.startsWith("<?xml ", 3)) {
            return svrl.substring(firstLineEnd + 1);
        }
        return svrl;
    }

    private String removePath(String filename) {
        String[] split = filename.split("/");
        return split[split.length - 1];
    }
}

