/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pageseeder.schematron.CompileOptions;
import org.pageseeder.schematron.OutputOptions;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.Validator;
import org.pageseeder.schematron.ValidatorFactory;
import org.pageseeder.schematron.svrl.AssertOrReport;
import org.pageseeder.schematron.svrl.SVRLParser;
import org.pageseeder.schematron.svrl.SchematronOutput;

public final class Main {
    private static final List<Option> AVAILABLE_OPTIONS = Arrays.asList(new Option('i', "input", true, "Path to XML file to validate (required)"), new Option('s', "schematron", true, "Path to Schematron file to use (required)"), new Option('o', "output", true, "Path to output file"), new Option('d', "detail", false, "Flag to include diagnotics and properties in text output"), new Option('v', "svrl", false, "Flag to return the results as SVRL instead of text"), new Option('m', "metadata", false, "Flag to include the metadata in SVRL"), new Option('p', "prefix-in-location", false, "Flag to use prefix in locations"), new Option('c', "compact", false, "Flag to only return asserts and reports in SVRL"), new Option('t', "indent", false, "Flag to indent the SVRL output"));
    private boolean details = false;
    private boolean svrl = false;
    private boolean metadata = false;
    private boolean compact = false;
    private boolean prefixInLocation = false;
    private boolean indent = false;
    private File input;
    private File schema;
    private File output;

    private Main() {
    }

    private boolean checkReady() {
        if (this.input == null) {
            System.err.println("No input specified, use -i option");
            return false;
        }
        if (!this.input.isFile()) {
            System.err.println("Input must be an existing file");
            return false;
        }
        if (this.schema == null) {
            System.err.println("No schema specified, use -s option");
            return false;
        }
        if (!this.schema.isFile()) {
            System.err.println("Schema must be an existing file");
            return false;
        }
        return true;
    }

    public void validate() throws SchematronException, IOException {
        ValidatorFactory factory = new ValidatorFactory();
        CompileOptions compileOptions = CompileOptions.defaults().metadata(this.metadata).compact(this.compact);
        factory.setOptions(compileOptions);
        Validator validator = factory.newValidator(this.schema);
        OutputOptions outputOptions = OutputOptions.defaults().indent(this.indent).usePrefixInLocation(this.prefixInLocation);
        SchematronResult result = validator.validate(this.input, outputOptions);
        if (this.output != null) {
            FileOutputStream out = new FileOutputStream(this.output);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            if (this.svrl) {
                writer.write(result.getSVRLAsString());
            } else {
                SchematronOutput output = SVRLParser.parse(new StringReader(result.getSVRLAsString()));
                for (AssertOrReport assertion : output.getAllAssertsOrReports()) {
                    writer.write(assertion.toMessageString());
                }
            }
            writer.flush();
            writer.close();
        } else if (this.svrl) {
            System.out.println(result.getSVRLAsString());
        } else {
            SchematronOutput output = SVRLParser.parse(new StringReader(result.getSVRLAsString()));
            for (AssertOrReport assertion : output.getAllAssertsOrReports()) {
                System.out.println(assertion.toMessageString(this.details));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        block7: {
            if (args.length == 0) {
                Main.printUsage();
                return;
            }
            ArgumentList argumentList = Main.parse(args);
            Main main = new Main();
            main.details = argumentList.hasOption('d');
            main.svrl = argumentList.hasOption('v');
            main.compact = argumentList.hasOption('c');
            main.metadata = argumentList.hasOption('m');
            main.prefixInLocation = argumentList.hasOption('p');
            main.indent = argumentList.hasOption('t');
            if (argumentList.hasOption('i')) {
                main.input = new File(argumentList.getValue('i'));
            }
            if (argumentList.hasOption('o')) {
                main.output = new File(argumentList.getValue('o'));
            }
            if (argumentList.hasOption('s')) {
                main.schema = new File(argumentList.getValue('s'));
            }
            if (!main.checkReady()) {
                Main.printUsage();
                return;
            }
            try {
                main.validate();
            }
            catch (SchematronException ex) {
                System.err.println(ex.getMessage());
                if (ex.getCause() == null) break block7;
                System.err.println(ex.getCause().getMessage());
            }
        }
    }

    public static void printUsage() {
        System.err.println("Schematron");
        System.err.println("java -cp pso-schematron.jar:Saxon.jar org.pageseeder.schematron.Main -i [filename] -s [filename]");
        System.err.println("usage:");
        for (Option option : AVAILABLE_OPTIONS) {
            System.err.print(" -" + option.letter + " or --" + Main.padded(option.word, option.arg, 20));
            System.err.println(option.description);
        }
    }

    private static String padded(String word, boolean hasValue, int max) {
        StringBuilder padding = new StringBuilder();
        padding.append(word);
        if (hasValue) {
            padding.append(" [path]");
            for (int i = 0; i < max - word.length() - 7; ++i) {
                padding.append(' ');
            }
        } else {
            for (int i = 0; i < max - word.length(); ++i) {
                padding.append(' ');
            }
        }
        return padding.toString();
    }

    private static boolean isFileSpecified(File f) {
        return f != null && f.isFile();
    }

    private static ArgumentList parse(String[] args) {
        ArgumentList arguments = new ArgumentList();
        List<String> options = Arrays.asList(args);
        Iterator<String> i = options.iterator();
        while (i.hasNext()) {
            String arg = i.next();
            for (Option option : AVAILABLE_OPTIONS) {
                if (!option.match(arg)) continue;
                if (option.arg) {
                    arguments.add(option, i.hasNext() ? i.next() : "");
                    continue;
                }
                arguments.add(option, "");
            }
        }
        return arguments;
    }

    private static final class Argument {
        private final Option option;
        private final String value;

        public Argument(Option option, String value) {
            this.option = option;
            this.value = value;
        }
    }

    private static final class ArgumentList {
        List<Argument> arguments = new ArrayList<Argument>();

        private ArgumentList() {
        }

        Argument get(char c) {
            for (Argument argument : this.arguments) {
                if (argument.option.letter != c) continue;
                return argument;
            }
            return null;
        }

        boolean hasOption(char c) {
            return this.get(c) != null;
        }

        String getValue(char c) {
            for (Argument argument : this.arguments) {
                if (argument.option.letter != c) continue;
                return argument.value;
            }
            return "";
        }

        void add(Option option, String value) {
            this.arguments.add(new Argument(option, value));
        }
    }

    private static final class Option {
        private final char letter;
        private final String word;
        private final boolean arg;
        private final String description;

        Option(char letter, String word, boolean arg, String description) {
            this.letter = letter;
            this.word = word;
            this.arg = arg;
            this.description = description;
        }

        boolean match(String arg) {
            return arg.equals("--" + this.word) || arg.equals("-" + this.letter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Option option = (Option)o;
            return this.letter == option.letter;
        }

        public int hashCode() {
            return this.letter;
        }
    }
}

