/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class CompileOptions {
    private static final CompileOptions DEFAULT = new CompileOptions("xslt", false, false, false);
    private static final CompileOptions DEFAULT_COMPATIBILITY = new CompileOptions("xslt2", false, false, false);
    private final String defaultQueryBinding;
    private final boolean streamable;
    private final boolean metadata;
    private final boolean compact;

    private CompileOptions(String defaultQueryBinding, boolean metadata, boolean streamable, boolean compact) {
        this.defaultQueryBinding = defaultQueryBinding;
        this.metadata = metadata;
        this.streamable = streamable;
        this.compact = compact;
    }

    public static CompileOptions defaults() {
        if ("1.0".equals(System.getProperty("org.pageseeder.schematron.compatibility"))) {
            return DEFAULT_COMPATIBILITY;
        }
        return DEFAULT;
    }

    public CompileOptions defaultQueryBinding(String defaultQueryBinding) {
        return new CompileOptions(defaultQueryBinding, this.metadata, this.streamable, this.compact);
    }

    public CompileOptions metadata(boolean metadata) {
        return new CompileOptions(this.defaultQueryBinding, metadata, this.streamable, this.compact);
    }

    public CompileOptions streamable(boolean streamable) {
        return new CompileOptions(this.defaultQueryBinding, this.metadata, streamable, this.compact);
    }

    public CompileOptions compact(boolean compact) {
        return new CompileOptions(this.defaultQueryBinding, this.metadata, this.streamable, compact);
    }

    public String defaultQueryBinding() {
        return this.defaultQueryBinding;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public boolean hasMetadata() {
        return this.metadata;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public Map<String, Object> toParameters() {
        return this.toParameters(null);
    }

    public Map<String, Object> toParameters(String phase) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (phase != null) {
            parameters.put("phase", phase);
        }
        parameters.put("schxslt.compile.streamable", this.streamable);
        parameters.put("schxslt.compile.metadata", this.metadata);
        parameters.put("schxslt.svrl.compact", this.compact);
        return parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompileOptions that = (CompileOptions)o;
        if (this.streamable != that.streamable) {
            return false;
        }
        if (this.metadata != that.metadata) {
            return false;
        }
        if (this.compact != that.compact) {
            return false;
        }
        return Objects.equals(this.defaultQueryBinding, that.defaultQueryBinding);
    }

    public int hashCode() {
        int result = this.defaultQueryBinding != null ? this.defaultQueryBinding.hashCode() : 0;
        result = 31 * result + (this.streamable ? 1 : 0);
        result = 31 * result + (this.metadata ? 1 : 0);
        result = 31 * result + (this.compact ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CompileOptions{defaultQueryBinding='" + this.defaultQueryBinding + '\'' + ", streamable=" + this.streamable + ", metadata=" + this.metadata + ", compact=" + this.compact + '}';
    }
}

