/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.Validator;

public final class ValidatorFactory {
    private static final String XSLT_ROOT = "/org/pageseeder/schematron/xslt";
    private static final String INCLUDE_PREPROCESSOR = "/org/pageseeder/schematron/xslt/iso_dsdl_include.xsl";
    private static final String ABSTRACT_PREPROCESSOR = "/org/pageseeder/schematron/xslt/iso_abstract_expand.xsl";
    private static final String PREPROCESSOR_MESSAGE_XSLT1 = "/org/pageseeder/schematron/xslt/iso_schematron_message.xsl";
    private static final String PREPROCESSOR_MESSAGE_XSLT2 = "/org/pageseeder/schematron/xslt/iso_schematron_message_xslt2.xsl";
    private static final String PREPROCESSOR_SVRL_XSLT1 = "/org/pageseeder/schematron/xslt/iso_svrl_for_xslt1.xsl";
    private static final String PREPROCESSOR_SVRL_XSLT2 = "/org/pageseeder/schematron/xslt/iso_svrl_for_xslt2.xsl";
    private TransformerFactory _factory = TransformerFactory.newInstance();
    private Class<URIResolver> _resolver;
    private ErrorListener _listener = this._factory.getErrorListener();
    private Map<String, Object> _parameters = new HashMap<String, Object>();
    private final Source _abstract_preprocessor;
    private final Source _include_preprocessor;
    private final Source _preprocessor;
    private boolean debugMode = false;

    public ValidatorFactory() {
        this._preprocessor = this.resolveDefaultPreprocessor();
        this._include_preprocessor = this.resolvePreprocessor(INCLUDE_PREPROCESSOR);
        this._abstract_preprocessor = this.resolvePreprocessor(ABSTRACT_PREPROCESSOR);
    }

    public ValidatorFactory(Source preprocessor) {
        if (preprocessor == null) {
            throw new NullPointerException("The preprocessor must not be null.");
        }
        this._preprocessor = preprocessor;
        this._include_preprocessor = this.resolvePreprocessor(INCLUDE_PREPROCESSOR);
        this._abstract_preprocessor = this.resolvePreprocessor(ABSTRACT_PREPROCESSOR);
    }

    public ValidatorFactory(QueryBinding binding, String formatter) {
        if (binding == null) {
            throw new NullPointerException("The preprocessor must not be null.");
        }
        String preprocessor = null;
        preprocessor = binding == QueryBinding.XSLT2 ? (formatter.equalsIgnoreCase("message") ? PREPROCESSOR_MESSAGE_XSLT2 : PREPROCESSOR_SVRL_XSLT2) : (binding == QueryBinding.XSLT1 ? (formatter.equalsIgnoreCase("message") ? PREPROCESSOR_MESSAGE_XSLT1 : PREPROCESSOR_SVRL_XSLT1) : (formatter.equalsIgnoreCase("message") ? PREPROCESSOR_MESSAGE_XSLT1 : PREPROCESSOR_SVRL_XSLT1));
        this._preprocessor = this.resolvePreprocessor(preprocessor);
        this._include_preprocessor = this.resolvePreprocessor(INCLUDE_PREPROCESSOR);
        this._abstract_preprocessor = this.resolvePreprocessor(ABSTRACT_PREPROCESSOR);
    }

    public void setErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("The error listener must not be null.");
        }
        this._listener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._listener;
    }

    public void setParameter(String name, Object value) {
        this._parameters.put(name, value);
    }

    public Object getParameter(String name) {
        return this._parameters.get(name);
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setResolver(Class<URIResolver> resolver) {
        this._resolver = resolver;
    }

    private Source resolveDefaultPreprocessor() {
        TransformerFactory f = TransformerFactory.newInstance();
        if (f.getClass().getName().startsWith("net.sf.saxon")) {
            return this.resolvePreprocessor(PREPROCESSOR_SVRL_XSLT2);
        }
        return this.resolvePreprocessor(PREPROCESSOR_SVRL_XSLT1);
    }

    private Source resolvePreprocessor(String stylesheet) {
        URL url = ValidatorFactory.class.getResource(stylesheet);
        if (url == null) {
            throw new IllegalArgumentException("preprocessor '" + stylesheet + "' cannot be found in the classpath.");
        }
        return new StreamSource(url.toString());
    }

    public Validator newValidator(File schema) throws SchematronException {
        if (!schema.exists()) {
            throw new SchematronException("Unable to find schema", new FileNotFoundException(schema.getPath()));
        }
        StreamSource source = new StreamSource(schema);
        return this.newValidator(source);
    }

    public Validator newValidator(Source schema) throws SchematronException {
        Transformer include_transformer = ValidatorFactory.compile(this._factory, this._include_preprocessor);
        Transformer abstract_transformer = ValidatorFactory.compile(this._factory, this._abstract_preprocessor);
        this._factory.setURIResolver(new XSLTURIFinder());
        Transformer transformer = ValidatorFactory.compile(this._factory, this._preprocessor);
        ValidatorFactory.prepare(include_transformer, this._listener, this._parameters);
        ValidatorFactory.prepare(abstract_transformer, this._listener, this._parameters);
        ValidatorFactory.prepare(transformer, this._listener, this._parameters);
        if (!this._factory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            throw new SchematronException("The XSLT processor must support following feature: http://javax.xml.transform.stream.StreamResult/feature");
        }
        Interim interim = new Interim(schema.getSystemId());
        try {
            DOMResult r1 = new DOMResult();
            include_transformer.transform(schema, r1);
            DOMResult r2 = new DOMResult();
            DOMSource s2 = new DOMSource(r1.getNode());
            abstract_transformer.transform(s2, r2);
            r1 = null;
            DOMSource s3 = new DOMSource(r2.getNode());
            transformer.transform(s3, interim.makeEmptyResult());
            r2 = null;
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to process " + schema.getSystemId() + " to generate new Validator", ex);
        }
        if (this.debugMode) {
            try {
                interim.saveAs(new File("debug.xslt"));
            }
            catch (IOException ex) {
                throw new SchematronException("Unable to save debug.xslt", ex);
            }
        }
        if (this._resolver != null) {
            try {
                this._factory.setURIResolver(this._resolver.newInstance());
            }
            catch (Throwable t) {
                throw new SchematronException("Unable to instantiate new resolver", t);
            }
        }
        Templates validator = null;
        try {
            validator = this._factory.newTemplates(interim.getSource());
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to generate new Validator from preprocessed " + schema.getSystemId(), ex);
        }
        return new Validator(validator);
    }

    private static Transformer compile(TransformerFactory factory, Source source) throws SchematronException {
        Transformer transformer = null;
        try {
            transformer = factory.newTransformer(source);
        }
        catch (TransformerConfigurationException ex) {
            throw new SchematronException("Unable to compile " + source.getSystemId() + " to generate new Validator", ex);
        }
        return transformer;
    }

    private static void prepare(Transformer transformer, ErrorListener listener, Map<String, Object> parameters) {
        transformer.setErrorListener(listener);
        if (!parameters.isEmpty()) {
            for (Map.Entry<String, Object> p : parameters.entrySet()) {
                String name = p.getKey();
                transformer.setParameter(name, p.getValue());
            }
        }
    }

    private static class XSLTURIFinder
    implements URIResolver {
        private XSLTURIFinder() {
        }

        @Override
        public Source resolve(String href, String base) {
            URL url;
            try {
                if (href == null || href.length() == 0) {
                    int bang = base.indexOf(33);
                    url = ValidatorFactory.class.getResource(base.substring(bang + 1));
                } else {
                    url = href.indexOf(58) != -1 ? ValidatorFactory.class.getResource(href) : ValidatorFactory.class.getResource("/" + href);
                }
                if (url == null) {
                    url = new URL(base.substring(0, base.lastIndexOf(47) + 1) + href);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            return new StreamSource(url.toString());
        }
    }

    private static class Interim {
        private StringWriter writer;
        private final String systemId;

        public Interim(String systemId) {
            this.systemId = systemId;
        }

        public Result makeEmptyResult() throws IllegalStateException {
            if (this.writer != null) {
                throw new IllegalStateException("The templates have already been produced.");
            }
            this.writer = new StringWriter();
            return new StreamResult(this.writer);
        }

        public Source getSource() throws IllegalStateException {
            if (this.writer == null) {
                throw new IllegalStateException("The templates have not been produced.");
            }
            StreamSource source = new StreamSource(new StringReader(this.writer.toString()));
            source.setPublicId("compiled:" + this.systemId);
            return source;
        }

        public void saveAs(File file) throws IOException {
            PrintStream pout = new PrintStream(file, "utf-8");
            pout.print(this.writer.toString());
            pout.close();
        }
    }

    public static enum QueryBinding {
        XSLT1,
        XSLT2,
        AUTO;

    }
}

