/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.pageseeder.schematron.SchematronResult;

public final class SchematronReport {
    private final Map<String, SchematronResult> results = new HashMap<String, SchematronResult>();

    public void add(SchematronResult result) {
        this.results.put(result.getSystemID(), result);
    }

    public SchematronResult get(String systemID) {
        return this.results.get(systemID);
    }

    public void saveAs(File file) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(new Date());
        PrintStream pout = new PrintStream(file, "UTF-8");
        pout.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        pout.println("<fileset date=\"" + date + "\">");
        for (Map.Entry<String, SchematronResult> entries : this.results.entrySet()) {
            String sourcefile = entries.getKey();
            String svrlfile = entries.getValue().getSVRLAsString();
            pout.println("<file name=\"" + this.removePath(sourcefile) + "\">");
            pout.println(svrlfile);
            pout.println("</file>");
        }
        pout.println("</fileset>");
        pout.close();
    }

    public void printLog(PrintStream out) {
        for (SchematronResult result : this.results.values()) {
            result.printAllMessage(out);
        }
    }

    private String removePath(String filename) {
        String[] splitted = filename.split("/");
        return splitted[splitted.length - 1];
    }
}

