/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronOptions;
import org.pageseeder.schematron.SchematronReport;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.Validator;
import org.pageseeder.schematron.ValidatorFactory;

@Deprecated
public final class Schematron {
    private ValidatorFactory.QueryBinding queryLanguageBinding = ValidatorFactory.QueryBinding.AUTO;
    private String format = "svrl";
    private File schema;
    private String outputDir;
    private String outputFilename = "result.xml";
    private final List<File> files = new ArrayList<File>();
    private Validator validator;
    private boolean failOnError = true;
    private boolean debugMode = false;
    private SchematronOptions options = new SchematronOptions();
    private String archiveNameParameter = null;
    private String archiveDirParameter = null;
    private String fileNameParameter = null;
    private String fileDirParameter = null;
    private String encoding = null;

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setQueryLanguageBinding(String binding) {
        this.queryLanguageBinding = ValidatorFactory.QueryBinding.valueOf(binding.toUpperCase());
    }

    public void setDebugMode(boolean debug) {
        this.debugMode = debug;
    }

    public void setSchema(File file) {
        this.schema = file;
    }

    public void setFile(File file) {
        this.files.clear();
        this.files.add(file);
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public void setCatalog(String data) {
        System.setProperty("xml.catalog.files", data);
    }

    public void setFileNameParameter(String value) {
        this.fileNameParameter = value;
    }

    public void setFileDirParameter(String value) {
        this.fileDirParameter = value;
    }

    public void setArchiveNameParameter(String value) {
        this.archiveNameParameter = value;
    }

    public void setarchiveDirParameter(String value) {
        this.archiveDirParameter = value;
    }

    public void setOutputEncoding(String value) {
        this.encoding = value;
    }

    public void execute() throws SchematronException {
        int fileProcessed = 0;
        if (this.files.isEmpty()) {
            throw new SchematronException("Specify at least one source - a file or a fileset.");
        }
        if (this.schema == null) {
            throw new SchematronException("Specify at least one schema.");
        }
        if (!(this.schema.exists() && this.schema.canRead() && this.schema.isFile())) {
            throw new SchematronException("Schema " + this.schema + " cannot be read");
        }
        this.initValidator();
        SchematronReport report = new SchematronReport();
        for (File f : this.files) {
            SchematronResult result = this.doValidate(f);
            if (this.failOnError && !result.isValid()) {
                result.printFailedMessage(System.err);
                return;
            }
            report.add(result);
            ++fileProcessed;
            Thread.yield();
        }
        try {
            File resultFile = new File(this.outputDir, this.outputFilename);
            report.saveAs(resultFile);
        }
        catch (IOException ex) {
            throw new SchematronException("Unable to write to file: " + ex.getMessage());
        }
        try {
            report.printLog(System.out);
        }
        catch (Exception ex) {
            throw new SchematronException(ex.getMessage());
        }
        System.out.println(fileProcessed + " file(s) have been successfully validated.");
    }

    private void initValidator() throws SchematronException {
        try {
            ValidatorFactory factory = new ValidatorFactory(this.queryLanguageBinding, this.format);
            factory.setDebugMode(this.debugMode);
            factory.setErrorListener(new Listener());
            this.options.configure(factory);
            System.out.println("Generating validator for schema " + this.schema + "... ");
            this.validator = factory.newValidator(new StreamSource(this.schema));
            System.out.println("Validator ready to process");
        }
        catch (Exception e) {
            System.out.println("Error with initializing validator: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private SchematronResult doValidate(File afile) throws SchematronException {
        System.out.println("Validating " + afile.getName() + "... ");
        StreamSource xml = new StreamSource(afile);
        SchematronResult result = this.validator.validate(xml, this.fileNameParameter, this.fileDirParameter, this.archiveNameParameter, this.archiveDirParameter, this.encoding);
        return result;
    }

    private class Listener
    implements ErrorListener {
        private Listener() {
        }

        @Override
        public void warning(TransformerException ex) {
            System.err.println("[warning] " + ex.getMessage());
        }

        @Override
        public void error(TransformerException ex) throws TransformerException {
            throw ex;
        }

        @Override
        public void fatalError(TransformerException ex) throws TransformerException {
            throw ex;
        }
    }
}

