/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.File;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;

public final class Validator {
    private final Templates _validator;
    private URIResolver _resolver;

    protected Validator(Templates templates) {
        if (templates == null) {
            throw new NullPointerException("A validator cannot be constructed with null templates");
        }
        this._validator = templates;
        this._resolver = null;
    }

    public void setResolver(URIResolver resolver) {
        this._resolver = resolver;
    }

    public SchematronResult validate(File xml) throws SchematronException {
        return this.validate(new StreamSource(xml));
    }

    public SchematronResult validate(Source xml) throws SchematronException {
        Transformer transformer = Validator.newTransformer(this._validator, this._resolver, "utf-8");
        String systemId = xml.getSystemId();
        String archiveId = "";
        if (systemId != null && (systemId.startsWith("jar:") || systemId.startsWith("zip:"))) {
            archiveId = systemId.substring(0, systemId.lastIndexOf(33));
            systemId = systemId.substring(systemId.lastIndexOf(33) + 1);
        }
        if (archiveId != null && archiveId.length() > 0) {
            transformer.setParameter("archiveNameParameter", archiveId.substring(archiveId.lastIndexOf(47) + 1));
        }
        if (archiveId != null && archiveId.length() > 0 && archiveId.lastIndexOf(47) > -1) {
            transformer.setParameter("archiveDirParameter", archiveId.substring(0, archiveId.lastIndexOf(47)));
        }
        if (systemId != null && systemId.length() > 0) {
            transformer.setParameter("fileNameParameter", systemId.substring(systemId.lastIndexOf(47) + 1));
        }
        if (systemId != null && systemId.length() > 0 && systemId.lastIndexOf(47) > -1) {
            transformer.setParameter("fileDirParameter", systemId.substring(0, systemId.lastIndexOf(47)));
        }
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(xml, new StreamResult(writer));
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to process file with schematron", ex);
        }
        SchematronResult result = new SchematronResult(xml.getSystemId());
        result.setSVRL(writer.toString());
        return result;
    }

    public SchematronResult validate(Source xml, String fnp, String fdp, String anp, String adp, String encoding) throws SchematronException {
        Transformer transformer = Validator.newTransformer(this._validator, this._resolver, encoding);
        String sid = xml.getSystemId();
        String aid = "";
        if (sid != null && (sid.startsWith("jar:") || sid.startsWith("zip:"))) {
            aid = sid.substring(0, sid.lastIndexOf("!"));
            sid = sid.substring(sid.lastIndexOf("!") + 1);
        }
        if (anp != null && anp.length() > 0) {
            transformer.setParameter("archiveNameParameter", anp);
        } else if (aid != null && aid.length() > 0) {
            transformer.setParameter("archiveNameParameter", aid.substring(aid.lastIndexOf("/") + 1));
        }
        if (adp != null && adp.length() > 0) {
            transformer.setParameter("archiveDirParameter", adp);
        } else if (aid != null && aid.length() > 0 && aid.lastIndexOf("/") > -1) {
            transformer.setParameter("archiveDirParameter", aid.substring(0, aid.lastIndexOf("/")));
        }
        if (fnp != null && fnp.length() > 0) {
            transformer.setParameter("fileNameParameter", fnp);
        } else if (sid != null && sid.length() > 0) {
            transformer.setParameter("fileNameParameter", sid.substring(sid.lastIndexOf("/") + 1));
        }
        if (fdp != null && fdp.length() > 0) {
            transformer.setParameter("fileDirParameter", fdp);
        } else if (sid != null && sid.length() > 0 && sid.lastIndexOf("/") > -1) {
            transformer.setParameter("fileDirParameter", sid.substring(0, sid.lastIndexOf("/")));
        }
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(xml, new StreamResult(writer));
        }
        catch (TransformerException ex) {
            throw new SchematronException("Unable to process file with schematron", ex);
        }
        SchematronResult result = new SchematronResult(xml.getSystemId());
        result.setSVRL(writer.toString());
        return result;
    }

    private static Transformer newTransformer(Templates validator, URIResolver resolver, String encoding) throws SchematronException {
        Transformer transformer = null;
        try {
            transformer = validator.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new SchematronException("Unable to create new validator", ex);
        }
        if (encoding != null && encoding.length() > 0) {
            transformer.setOutputProperty("encoding", encoding);
        }
        transformer.setOutputProperty("indent", "yes");
        if (resolver != null) {
            transformer.setURIResolver(resolver);
        }
        return transformer;
    }
}

