/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.schematron.SVRLHandler;
import org.pageseeder.schematron.SchematronException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SchematronResult {
    private String systemID;
    private String svrl;
    private final List<String> failedAssertions = new ArrayList<String>();
    private final List<String> successfulReports = new ArrayList<String>();

    public SchematronResult(String systemID) {
        this.systemID = systemID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public boolean isValid() {
        return this.failedAssertions.size() == 0;
    }

    public void setSVRL(String svrl) throws SchematronException {
        this.svrl = this.removeXMLheader(svrl);
        try {
            this.parseSVRL();
        }
        catch (Exception ex) {
            this.svrl = svrl;
        }
    }

    public String getSVRLAsString() {
        return this.svrl;
    }

    public void printFailedMessage(PrintStream out) {
        if (this.failedAssertions.size() > 0) {
            out.println("Source file: " + this.removePath(this.systemID));
            for (int i = 0; i < this.failedAssertions.size(); ++i) {
                out.println(this.failedAssertions.get(i));
            }
        }
    }

    public String getFailedMessage() {
        String erroutput = "";
        if (this.failedAssertions.size() > 0) {
            for (int i = 0; i < this.failedAssertions.size(); ++i) {
                erroutput = erroutput + this.failedAssertions.get(i);
            }
        }
        return erroutput;
    }

    public void printAllMessage(PrintStream out) {
        if (this.failedAssertions.size() > 0 || this.successfulReports.size() > 0) {
            if (this.systemID != null) {
                out.println("Source file: " + this.removePath(this.systemID));
            }
            for (String assertion : this.failedAssertions) {
                out.println(assertion);
            }
            for (String report : this.successfulReports) {
                out.println(report);
            }
        }
    }

    public List<String> getFailedAssertions() {
        return this.failedAssertions;
    }

    public List<String> getSuccessfulReports() {
        return this.successfulReports;
    }

    private void parseSVRL() throws IOException, SAXException, ParserConfigurationException {
        SVRLHandler handler = new SVRLHandler(this.failedAssertions, this.successfulReports);
        InputSource is = new InputSource(new StringReader(this.svrl));
        is.setEncoding("UTF-16");
        SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)handler);
    }

    private String removeXMLheader(String svrl) {
        int firstLineEnd = svrl.indexOf("\n");
        if (svrl.startsWith("<?xml ") || svrl.startsWith("<?xml ", 1) || svrl.startsWith("<?xml ", 2) || svrl.startsWith("<?xml ", 3)) {
            return svrl.substring(firstLineEnd + 1);
        }
        return svrl;
    }

    private String removePath(String filename) {
        String[] splitted = filename.split("/");
        return splitted[splitted.length - 1];
    }
}

