/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.ixml;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.ixml.IndexParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class IndexParserFactory
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexParserFactory.class);

    public static IndexParser getInstanceForTransformation(String catalog) {
        return new IndexParser(catalog);
    }

    public static IndexParser getInstance() throws IndexException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(false);
            factory.setFeature("http://xml.org/sax/features/validation", true);
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            return new IndexParser(reader);
        }
        catch (ParserConfigurationException | SAXException ex) {
            LOGGER.error("Error while generating index document parser instance.", (Throwable)ex);
            throw new IndexException("An error occurred when trying to generate a parser instance.", ex);
        }
    }
}

