/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Catalogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(Catalogs.class);
    private static final HashMap<String, Catalog> CACHE = new HashMap();
    private static File ROOT = null;

    public static void setRoot(File root) {
        ROOT = root;
    }

    public static void newField(String catalog, FlintField builder) {
        if (catalog == null || builder == null) {
            return;
        }
        Catalog cat = Catalogs.getCatalog(catalog);
        if (cat == null) {
            cat = new Catalog(catalog);
            Catalogs.putCatalog(cat);
        }
        cat.addFieldType(builder);
    }

    public static boolean updateField(FlintField field) {
        Catalog.CatalogEntry newOne;
        Catalog.CatalogEntry existing;
        if (field == null || field.catalog() == null) {
            return false;
        }
        if (field.index() == FlintField.IndexOptions.NONE) {
            return false;
        }
        Catalog cat = Catalogs.getCatalog(field.catalog());
        Catalog.CatalogEntry catalogEntry = existing = cat == null ? null : cat.get(field.name());
        if (existing != null && !(newOne = new Catalog.CatalogEntry(field, false)).equalsButDocValues(existing)) {
            existing.update(field);
            return true;
        }
        return false;
    }

    public static void putCatalog(Catalog catalog) {
        if (catalog == null) {
            return;
        }
        CACHE.put(catalog.name(), catalog);
    }

    public static Catalog getCatalog(String name) {
        if (name == null) {
            return null;
        }
        Catalog cat = CACHE.get(name);
        if (cat == null) {
            if (ROOT == null) {
                return null;
            }
            File file = new File(ROOT, name + "-catalog.xml");
            if (!file.exists()) {
                LOGGER.debug("Looking for non existent catalog file for {}", (Object)name);
                return null;
            }
            try (FileInputStream in = new FileInputStream(file);){
                cat = Catalogs.loadCatalog(name, in);
            }
            catch (FileNotFoundException ex) {
                LOGGER.warn("Looking for invalid catalog file for {}", (Object)name, (Object)ex);
                return null;
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to read catalog file for {}", (Object)name, (Object)ex);
                return null;
            }
            if (cat != null) {
                CACHE.put(name, cat);
            }
        }
        return cat;
    }

    public static void save(String catalog) {
        Catalog thecatalog = CACHE.get(catalog);
        if (thecatalog != null) {
            Catalogs.saveCatalog(thecatalog);
        }
    }

    public static void saveAll() {
        for (Catalog catalog : CACHE.values()) {
            Catalogs.saveCatalog(catalog);
        }
    }

    public static Catalog loadCatalog(String name, InputStream in) {
        CatalogHandler handler = new CatalogHandler(name);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setContentHandler(handler);
            reader.parse(new InputSource(in));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load catalog file for {}", (Object)name, (Object)ex);
            return null;
        }
        catch (SAXException ex) {
            LOGGER.error("Failed to parse catalog file for {}", (Object)name, (Object)ex);
            return null;
        }
        return handler.catalog;
    }

    private static void saveCatalog(Catalog catalog) {
        if (ROOT == null) {
            LOGGER.error("Trying to save catalog file when no root folder has been specified");
            return;
        }
        File file = new File(ROOT, catalog.name() + "-catalog.xml");
        file.getParentFile().mkdirs();
        try {
            if (!file.exists() && !file.createNewFile()) {
                LOGGER.warn("Failed to create new catalog file for {}", (Object)catalog.name());
                return;
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to create new catalog file for {}", (Object)catalog.name(), (Object)ex);
        }
        try (FileWriter out = new FileWriter(file);){
            XMLWriterImpl xml = new XMLWriterImpl((Writer)out, true);
            catalog.toXML((XMLWriter)xml);
            xml.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to save catalog file for {}", (Object)catalog.name(), (Object)ex);
        }
    }

    public static class CatalogHandler
    extends DefaultHandler {
        private final Catalog catalog;

        public CatalogHandler(String name) {
            this.catalog = new Catalog(name);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if ("field".equals(localName) && (name = attributes.getValue("name")) != null) {
                boolean stored = "true".equals(attributes.getValue("stored"));
                boolean tokenized = "true".equals(attributes.getValue("tokenized"));
                FlintField.NumericType num = FlintField.toNumeric(attributes.getValue("numeric-type"));
                FlintField.DocValuesType dv = FlintField.toDocValues(attributes.getValue("doc-values"), num != null);
                SimpleDateFormat df = FlintField.toDateFormat(attributes.getValue("date-format"));
                FlintField.Resolution res = FlintField.toResolution(attributes.getValue("date-resolution"));
                this.catalog.addFieldType(stored, name, tokenized, dv, num, df, res);
            }
        }
    }
}

