/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.IndexManager;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.templates.TemplatesCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Index {
    private static final Logger LOGGER = LoggerFactory.getLogger(Index.class);
    private final String _id;
    private final String _catalog;
    private final Map<ContentDefinition, URI> _templates = new ConcurrentHashMap<ContentDefinition, URI>();

    public Index(String id) {
        this(id, null);
    }

    public Index(String id, String catalog) {
        this._id = id;
        this._catalog = catalog;
        IndexManager.registerIndex(this);
    }

    public String getCatalog() {
        return this._catalog;
    }

    public final String getIndexID() {
        return this._id;
    }

    public void close() {
        IndexIO io = this.getIndexIO();
        if (io != null) {
            try {
                io.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to stop IndexIO for {}", (Object)this._id, (Object)ex);
            }
        }
        IndexManager.deregisterIndex(this);
    }

    public abstract IndexIO getIndexIO();

    public Collection<FlintField> getFields(Content content) {
        return null;
    }

    public Map<String, String> getParameters(Content content) {
        return null;
    }

    public Templates getTemplates(ContentType type, String media) {
        ContentDefinition def = new ContentDefinition(type, media);
        URI uri = this._templates.get(def);
        try {
            return uri == null ? null : TemplatesCache.get(uri);
        }
        catch (TransformerException ex) {
            return null;
        }
    }

    public void setTemplates(ContentType type, String media, URI template) throws TransformerException {
        TemplatesCache.get(template);
        ContentDefinition def = new ContentDefinition(type, media);
        LOGGER.debug("Adding templates for {}", (Object)def);
        this._templates.put(def, template);
    }

    public void removeTemplate(ContentType type, String media) {
        ContentDefinition def = new ContentDefinition(type, media);
        this._templates.remove(def);
    }

    public void clearTemplates() {
        this._templates.clear();
    }

    private static final class ContentDefinition {
        private final ContentType _type;
        private final String _media;
        private final int hashCode;

        public ContentDefinition(ContentType type, String media) {
            this._type = type;
            this._media = media;
            this.hashCode = ContentDefinition.hashCode(type, media);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ContentDefinition)) {
                return false;
            }
            return this.equals((ContentDefinition)o);
        }

        public boolean equals(ContentDefinition def) {
            if (def == null) {
                return false;
            }
            if (this == def) {
                return true;
            }
            if (!this._type.equals(def._type)) {
                return false;
            }
            return this._media == null && def._media == null || this._media.equals(def._media);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this._type.toString() + "|" + this._media;
        }

        private static int hashCode(ContentType type, String media) {
            return type.hashCode() * 13 + (media == null ? 0 : media.hashCode() * 19);
        }
    }
}

