/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.indexing;

import java.util.HashMap;
import java.util.Map;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.Requester;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.IndexBatch;

public class IndexJob
implements Comparable<IndexJob> {
    private static final ContentType CLEAR_CONTENT_TYPE = new ContentType(){

        public String toString() {
            return IndexJob.CLEAR_CONTENT_ID;
        }
    };
    private static final String CLEAR_CONTENT_ID = "CLEAR";
    private final String _contentid;
    private final ContentType _contenttype;
    private final Priority _priority;
    private final Index _index;
    private final Requester _requester;
    private final long _created;
    private boolean finished = false;
    private final String jobId;
    private final IndexBatch batch;
    private boolean success = false;
    private final Map<String, String> parameters = new HashMap<String, String>();

    private IndexJob(IndexBatch b, String cid, ContentType ctype, Index i, Priority p, Requester r, Map<String, String> params) {
        this._contentid = cid;
        this.batch = b;
        this._contenttype = ctype;
        this._priority = p;
        this._requester = r;
        this._index = i;
        this._created = System.nanoTime();
        this.jobId = this._created + 45L + cid + "-" + ctype + "-" + i.getIndexID() + "-" + r.getRequesterID() + "-" + p.toString();
        if (params != null) {
            this.parameters.putAll(params);
        }
    }

    protected String getJobID() {
        return this.jobId;
    }

    public boolean isBatch() {
        return this.batch != null;
    }

    public IndexBatch getBatch() {
        return this.batch;
    }

    public String getContentID() {
        return this._contentid;
    }

    public ContentType getContentType() {
        return this._contenttype;
    }

    public String getCatalog() {
        return this._index.getCatalog();
    }

    public Priority getPriority() {
        return this._priority;
    }

    public Index getIndex() {
        return this._index;
    }

    public Requester getRequester() {
        return this._requester;
    }

    public boolean isForRequester(Requester request) {
        if (this._requester == request) {
            return true;
        }
        return this._requester.getRequesterID().equals(request.getRequesterID());
    }

    public boolean isForIndex(Index index) {
        if (this._index == index) {
            return true;
        }
        return this._index != null && this._index.getIndexID().equals(index.getIndexID());
    }

    @Override
    public int compareTo(IndexJob job) {
        return this._priority == job._priority ? Long.compare(this._created, job._created) : (this._priority == Priority.HIGH ? -1 : 1);
    }

    public boolean isSimilar(IndexJob other) {
        return other != null && this._contentid.equals(other._contentid) && this._contenttype.equals(other._contenttype) && this._index.getIndexID().equals(other._index.getIndexID()) && this.parameters.equals(other.parameters);
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    public String toString() {
        return "[IndexJob - contentid:" + this._contentid + " priority:" + this._priority + " index:" + this._index + " finished:" + this.finished + " success:" + this.success + "]";
    }

    public boolean isClearJob() {
        return CLEAR_CONTENT_ID.equals(this._contentid) && CLEAR_CONTENT_TYPE.equals(this._contenttype);
    }

    public static IndexJob newBatchJob(IndexBatch b, String contentid, ContentType ctype, Index i, Priority p, Requester r, Map<String, String> params) {
        return new IndexJob(b, contentid, ctype, i, p, r, params);
    }

    public static IndexJob newJob(String contentid, ContentType ctype, Index i, Priority p, Requester r, Map<String, String> params) {
        return new IndexJob(null, contentid, ctype, i, p, r, params);
    }

    public static IndexJob newClearJob(Index index, Priority priority, Requester requester) {
        return new IndexJob(null, CLEAR_CONTENT_ID, CLEAR_CONTENT_TYPE, index, priority, requester, null);
    }

    public static enum Priority {
        HIGH,
        LOW;

    }
}

