/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.ixml;

import java.util.ArrayList;
import java.util.List;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.ixml.IndexDocumentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class IndexDocumentHandler_5_0
extends DefaultHandler
implements IndexDocumentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexDocumentHandler_5_0.class);
    private final String _catalog;
    private List<FlintDocument> documents;
    private FlintDocument _document;
    private boolean _isField;
    private boolean _isCompressed;
    private FlintField field = null;
    private StringBuilder _value = new StringBuilder();

    public IndexDocumentHandler_5_0(String catalog) {
        this._catalog = catalog;
    }

    @Override
    public List<FlintDocument> getDocuments() {
        return this.documents;
    }

    @Override
    public void startDocument() {
        this.documents = new ArrayList<FlintDocument>();
        this.field = new FlintField(this._catalog);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("field".equals(qName)) {
            this.startFieldElement(attributes);
        } else if ("document".equals(qName)) {
            this.startDocumentElement(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("field".equals(qName)) {
            this.endFieldElement();
        } else if ("document".equals(qName)) {
            this.endDocumentElement();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._isField) {
            this._value.append(ch, start, length);
        }
    }

    private void startDocumentElement(Attributes atts) {
        this._document = new FlintDocument();
    }

    private void endDocumentElement() {
        if (this._document.isEmpty()) {
            LOGGER.warn("This document is empty - will not be stored");
        } else {
            this.documents.add(this._document);
        }
        this._document = null;
    }

    private void startFieldElement(Attributes atts) {
        this.field.name(atts.getValue("name")).index(atts.getValue("index"));
        if ("compress".equals(atts.getValue("store"))) {
            this._isCompressed = true;
            this.field.store(false);
        } else {
            this._isCompressed = false;
            this.field.store(atts.getValue("store"));
        }
        String numType = atts.getValue("numeric-type");
        if (numType != null) {
            this.field.numeric(numType).precisionStep(atts.getValue("precision-step"));
        }
        this.field.termVector(atts.getValue("term-vector")).termVectorPositions(atts.getValue("term-vector-positions")).termVectorOffsets(atts.getValue("term-vector-offsets")).termVectorPayloads(atts.getValue("term-vector-payloads")).boost(atts.getValue("boost")).tokenize(atts.getValue("tokenize")).docValues(atts.getValue("doc-values"), numType != null);
        this.field.dateFormat(atts.getValue("date-format")).resolution(atts.getValue("date-resolution"));
        this._isField = true;
    }

    private void endFieldElement() {
        try {
            this.field.value(this._value.toString());
            if (this._isCompressed) {
                if (this.field.index() != FlintField.IndexOptions.NONE) {
                    this._document.add(this.field);
                }
                this._document.add(this.field.cloneCompressed());
            } else {
                if (this.field.isDocValues()) {
                    this._document.add(this.field.cloneNoDocValues());
                }
                this._document.add(this.field);
            }
        }
        catch (IllegalStateException ex) {
            LOGGER.warn("Unable to create field: " + this.field.name(), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Unable to create field: " + this.field.name(), (Throwable)ex);
        }
        this.field = new FlintField(this._catalog);
        this._isField = false;
        this._isCompressed = false;
        this._value.setLength(0);
    }
}

