/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.indexing;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlintField {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final float DEFAULT_BOOST_VALUE = 1.0f;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlintField.class);
    private final String _catalog;
    private String _name;
    private boolean _store = true;
    private boolean _tokenize = true;
    private DocValuesType _docValues = DocValuesType.NONE;
    private IndexOptions _index = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
    private boolean _omitNorms = false;
    private boolean _vector = true;
    private boolean _vectorPositions = true;
    private boolean _vectorPayloads = true;
    private boolean _vectorOffsets = true;
    private SimpleDateFormat _dateformat;
    private Resolution _resolution;
    private CharSequence _value;
    private NumericType _numeric;
    private Integer _precisionStep = null;
    private boolean _compressed = false;
    private float _boost = 1.0f;

    public FlintField(String catalog) {
        this._catalog = catalog;
    }

    public FlintField cloneCompressed() {
        FlintField compressed = new FlintField(this._catalog);
        compressed.name(this._name);
        if (this._value != null) {
            compressed.value(this._value.toString());
        }
        compressed.boost(this._boost);
        compressed.compressed(true);
        return compressed;
    }

    public FlintField cloneNoDocValues() {
        FlintField cloned = new FlintField(this._catalog);
        cloned._name = this._name;
        cloned._value = this._value;
        cloned._boost = this._boost;
        cloned._compressed = this._compressed;
        cloned._dateformat = this._dateformat;
        cloned._index = this._index;
        cloned._numeric = this._numeric;
        cloned._omitNorms = this._omitNorms;
        cloned._precisionStep = this._precisionStep;
        cloned._resolution = this._resolution;
        cloned._store = this._store;
        cloned._tokenize = this._tokenize;
        cloned._vector = this._vector;
        cloned._vectorOffsets = this._vectorOffsets;
        cloned._vectorPayloads = this._vectorPayloads;
        cloned._vectorPositions = this._vectorPositions;
        cloned._docValues = DocValuesType.FORCED_NONE;
        return cloned;
    }

    public FlintField name(String name) {
        this._name = name;
        return this;
    }

    public FlintField value(String value) {
        this._value = value;
        return this;
    }

    public FlintField compressed(boolean compressed) {
        this._compressed = compressed;
        return this;
    }

    public FlintField store(boolean store) {
        this._store = store;
        return this;
    }

    public FlintField store(String store) {
        if (store != null) {
            this._store = Boolean.parseBoolean(store);
        }
        return this;
    }

    public FlintField tokenize(boolean tokenize) {
        this._tokenize = tokenize;
        return this;
    }

    public FlintField tokenize(String tokenize) {
        if (tokenize != null) {
            this._tokenize = Boolean.parseBoolean(tokenize);
        }
        return this;
    }

    public FlintField index(IndexOptions index) {
        this._index = index;
        return this;
    }

    public FlintField omitNorms(boolean omit) {
        this._omitNorms = omit;
        return this;
    }

    public FlintField index(String index) {
        if (index != null) {
            this._index = FlintField.toIndexOptions(index);
        }
        return this;
    }

    public FlintField docValues(DocValuesType docValues) {
        this._docValues = docValues == null ? DocValuesType.NONE : docValues;
        return this;
    }

    public FlintField docValues(String docValues, boolean numeric) {
        this._docValues = FlintField.toDocValues(docValues, numeric);
        return this;
    }

    public FlintField termVector(boolean vector) {
        this._vector = vector;
        return this;
    }

    public FlintField termVectorOffsets(boolean vectorOffsets) {
        this._vectorOffsets = vectorOffsets;
        return this;
    }

    public FlintField termVectorPositions(boolean vectorPositions) {
        this._vectorPositions = vectorPositions;
        return this;
    }

    public FlintField termVectorPayloads(boolean vectorPayloads) {
        this._vectorPayloads = vectorPayloads;
        return this;
    }

    public FlintField termVector(String vector) {
        if (vector != null) {
            this._vector = Boolean.parseBoolean(vector);
        }
        return this;
    }

    public FlintField termVectorOffsets(String vectorOffsets) {
        if (vectorOffsets != null) {
            this._vectorOffsets = Boolean.parseBoolean(vectorOffsets);
        }
        return this;
    }

    public FlintField termVectorPositions(String vectorPositions) {
        if (vectorPositions != null) {
            this._vectorPositions = Boolean.parseBoolean(vectorPositions);
        }
        return this;
    }

    public FlintField termVectorPayloads(String vectorPayloads) {
        if (vectorPayloads != null) {
            this._vectorPayloads = Boolean.parseBoolean(vectorPayloads);
        }
        return this;
    }

    public FlintField boost(float boost) {
        this._boost = boost;
        return this;
    }

    public FlintField boost(String boost) {
        if (boost != null) {
            this._boost = FlintField.toBoost(boost);
        }
        return this;
    }

    public FlintField dateFormat(SimpleDateFormat dateformat) {
        this._dateformat = dateformat;
        return this;
    }

    public FlintField dateFormat(String dateformat) {
        this._dateformat = FlintField.toDateFormat(dateformat);
        return this;
    }

    public FlintField resolution(Resolution resolution) {
        this._resolution = resolution;
        return this;
    }

    public FlintField resolution(String resolution) {
        if (resolution != null) {
            this._resolution = FlintField.toResolution(resolution);
        }
        return this;
    }

    protected FlintField numeric(NumericType type) {
        this._numeric = type;
        return this;
    }

    public FlintField numeric(String type) {
        if (type != null) {
            this._numeric = FlintField.toNumeric(type);
        }
        return this;
    }

    public FlintField precisionStep(int precision) {
        this._precisionStep = precision;
        return this;
    }

    public FlintField precisionStep(String precision) {
        if (precision == null) {
            return this;
        }
        try {
            this._precisionStep = Integer.parseInt(precision);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Unable to parse precision step {} as an integer - ignored and used default", (Object)precision);
        }
        return this;
    }

    public String name() {
        return this._name;
    }

    public String catalog() {
        return this._catalog;
    }

    public CharSequence value() {
        return this._value;
    }

    public boolean store() {
        return this._store;
    }

    public boolean tokenize() {
        return this._tokenize;
    }

    public IndexOptions index() {
        return this._index;
    }

    public float boost() {
        return this._boost;
    }

    public NumericType numericType() {
        return this._numeric;
    }

    public boolean isDocValues() {
        return this._docValues != DocValuesType.NONE && this._docValues != DocValuesType.FORCED_NONE;
    }

    public boolean isNumeric() {
        return this._numeric != null;
    }

    public DocValuesType docValues() {
        return this._docValues;
    }

    public boolean compressed() {
        return this._compressed;
    }

    public NumericType numeric() {
        return this._numeric;
    }

    public SimpleDateFormat dateformat() {
        return this._dateformat;
    }

    public Integer precisionStep() {
        return this._precisionStep;
    }

    public Resolution resolution() {
        return this._resolution;
    }

    public boolean omitNorms() {
        return this._omitNorms;
    }

    public boolean termVector() {
        return this._vector;
    }

    public boolean termVectorOffsets() {
        return this._vectorOffsets;
    }

    public boolean termVectorPayloads() {
        return this._vectorPayloads;
    }

    public boolean termVectorPositions() {
        return this._vectorPositions;
    }

    public static IndexOptions toIndexOptions(String index) {
        if (index == null) {
            return null;
        }
        try {
            return IndexOptions.valueOf(index.toUpperCase().replace('-', '_'));
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Invalid index option: {}", (Object)index);
            return null;
        }
    }

    public static Resolution toResolution(String resolution) {
        if (resolution == null) {
            return null;
        }
        if ("year".equals(resolution)) {
            return Resolution.YEAR;
        }
        if ("month".equals(resolution)) {
            return Resolution.MONTH;
        }
        if ("day".equals(resolution)) {
            return Resolution.DAY;
        }
        if ("hour".equals(resolution)) {
            return Resolution.HOUR;
        }
        if ("minute".equals(resolution)) {
            return Resolution.MINUTE;
        }
        if ("second".equals(resolution)) {
            return Resolution.SECOND;
        }
        if ("milli".equals(resolution)) {
            return Resolution.MILLISECOND;
        }
        if ("millisecond".equals(resolution)) {
            return Resolution.MILLISECOND;
        }
        LOGGER.warn("Invalid date resolution: {}, defaulting to Resolution.DAY", (Object)resolution);
        return Resolution.DAY;
    }

    public static NumericType toNumeric(String type) {
        if (type == null) {
            return null;
        }
        for (NumericType nt : NumericType.values()) {
            if (!type.equalsIgnoreCase(nt.name())) continue;
            return nt;
        }
        LOGGER.warn("Invalid number type : {}, defaulting to null (string)", (Object)type);
        return null;
    }

    public static DocValuesType toDocValues(String type, boolean numeric) {
        if (type == null) {
            return DocValuesType.NONE;
        }
        if ("sorted".equals(type)) {
            return numeric ? DocValuesType.SORTED_NUMERIC : DocValuesType.SORTED;
        }
        if ("sorted-set".equals(type)) {
            return DocValuesType.SORTED_SET;
        }
        if ("none".equals(type)) {
            return DocValuesType.NONE;
        }
        LOGGER.warn("Invalid doc values type : {}, defaulting to none", (Object)type);
        return DocValuesType.NONE;
    }

    public static float toBoost(String boost) {
        if (boost == null) {
            return 1.0f;
        }
        try {
            return Float.parseFloat(boost);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Could not parse boost value '{}' as float, using {}", (Object)boost, (Object)Float.valueOf(1.0f));
            return 1.0f;
        }
    }

    public static SimpleDateFormat toDateFormat(String format) {
        if (format == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            df.setTimeZone(GMT);
            return df;
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Ignoring unusable date format '" + format + "'", (Throwable)ex);
            return null;
        }
    }

    public static enum Resolution {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }

    public static enum IndexOptions {
        NONE,
        DOCS,
        DOCS_AND_FREQS,
        DOCS_AND_FREQS_AND_POSITIONS,
        DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;

    }

    public static enum DocValuesType {
        NONE,
        FORCED_NONE,
        SORTED,
        SORTED_NUMERIC,
        SORTED_SET;

    }

    public static enum NumericType {
        INT,
        FLOAT,
        DOUBLE,
        LONG;

    }
}

