/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.log;

import java.io.PrintStream;
import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexListener;

public final class PrintStreamListener
implements IndexListener {
    private final PrintStream _stream;

    public PrintStreamListener(PrintStream stream) {
        this._stream = stream;
    }

    @Override
    public void warn(IndexJob job, String message) {
        this._stream.println("[WARN ] " + message + ' ' + job.toString());
    }

    @Override
    public void error(IndexJob job, String message, Throwable throwable) {
        this._stream.println("[ERROR] " + message + ' ' + job.toString());
        if (throwable != null) {
            throwable.printStackTrace(this._stream);
        }
    }

    @Override
    public void endJob(IndexJob job) {
        this._stream.println("[JOB END] " + job.toString());
    }

    @Override
    public void startJob(IndexJob job) {
        this._stream.println("[JOB START] " + job.toString());
    }

    @Override
    public void startBatch(IndexBatch batch) {
        this._stream.println("[BATCH START] ");
    }

    @Override
    public void endBatch(IndexBatch batch) {
        this._stream.println("[BATCH END] " + batch.getTotalDocuments() + " documents");
    }
}

