/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.local;

import java.util.Collections;
import java.util.List;
import org.pageseeder.flint.indexing.IndexListener;
import org.pageseeder.flint.local.LocalIndexManager;
import org.pageseeder.flint.log.NoOpListener;

public class LocalIndexManagerFactory {
    private static final List<String> XML_ONLY = Collections.singletonList("xml");

    private LocalIndexManagerFactory() {
    }

    public static LocalIndexManager createMultiThreads() {
        return new LocalIndexManager(XML_ONLY);
    }

    public static LocalIndexManager createMultiThreads(IndexListener listener) {
        return new LocalIndexManager(listener, XML_ONLY);
    }

    public static LocalIndexManager createMultiThreads(int threads) {
        return LocalIndexManagerFactory.createMultiThreads(threads, NoOpListener.getInstance());
    }

    public static LocalIndexManager createMultiThreads(int threads, IndexListener listener) {
        return LocalIndexManagerFactory.createMultiThreads(threads, listener, XML_ONLY);
    }

    public static LocalIndexManager createMultiThreads(int threads, IndexListener listener, List<String> extensions) {
        return new LocalIndexManager(listener, threads, false, extensions);
    }

    public static LocalIndexManager createSingleThread() {
        return LocalIndexManagerFactory.createSingleThread(NoOpListener.getInstance());
    }

    public static LocalIndexManager createSingleThread(IndexListener listener) {
        return LocalIndexManagerFactory.createSingleThread(listener, XML_ONLY);
    }

    public static LocalIndexManager createSingleThread(IndexListener listener, List<String> extensions) {
        return LocalIndexManagerFactory.create(listener, 1, false, extensions);
    }

    public static LocalIndexManager create(IndexListener listener, int threads, boolean single, List<String> extensions) {
        return new LocalIndexManager(listener, threads, single, extensions);
    }
}

