/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.ixml;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.ixml.IndexDocumentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class IndexDocumentHandler_2_0
extends DefaultHandler
implements IndexDocumentHandler {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexDocumentHandler_2_0.class);
    private TimeZone _timezone = TimeZone.getDefault();
    private final Map<String, SimpleDateFormat> dfs = new HashMap<String, SimpleDateFormat>();
    private List<FlintDocument> documents;
    private FlintDocument _document;
    private boolean _isField;
    private boolean _isCompressed;
    private FlintField field = new FlintField(null);
    private StringBuilder _value = new StringBuilder();

    IndexDocumentHandler_2_0() {
    }

    @Override
    public List<FlintDocument> getDocuments() {
        return this.documents;
    }

    @Override
    public void startDocument() {
        LOGGER.debug("Start processing iXML document (version 2.0)");
        this.documents = new ArrayList<FlintDocument>();
    }

    @Override
    public void endDocument() {
        LOGGER.debug("End processing iXML document");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("field".equals(qName)) {
            this.startFieldElement(attributes);
        } else if ("document".equals(qName)) {
            this.startDocumentElement(attributes);
        } else if ("documents".equals(qName)) {
            this.startDocumentsElement(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("field".equals(qName)) {
            this.endFieldElement();
        } else if ("document".equals(qName)) {
            this.endDocumentElement();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._isField) {
            this._value.append(ch, start, length);
        }
    }

    private void startDocumentsElement(Attributes atts) {
        LOGGER.debug("Parsing index document set");
        String timezone = atts.getValue("timezone");
        if (timezone != null) {
            LOGGER.debug("Setting timezone to");
            this._timezone = TimeZone.getTimeZone(timezone);
        } else {
            this._timezone = GMT;
        }
    }

    private void startDocumentElement(Attributes atts) {
        LOGGER.debug("Parsing index document");
        this._document = new FlintDocument();
    }

    private void endDocumentElement() {
        LOGGER.debug("Storing document");
        if (this._document.isEmpty()) {
            LOGGER.warn("This document is empty - will not be stored");
        } else {
            this.documents.add(this._document);
        }
        this._document = null;
    }

    private void startFieldElement(Attributes atts) {
        this.field.name(atts.getValue("name"));
        this.indexAttribute(atts.getValue("index"));
        if ("compress".equals(atts.getValue("store"))) {
            this._isCompressed = true;
            this.field.store(false);
        } else {
            this._isCompressed = false;
            this.storeAttribute(atts.getValue("store"));
        }
        this.termVectorAttribute(atts.getValue("term-vector"));
        this.field.boost(atts.getValue("boost"));
        this.field.dateFormat(this.toDateFormat(atts.getValue("date-format")));
        this.field.resolution(atts.getValue("date-resolution"));
        String type = atts.getValue("numeric-type");
        if (type != null) {
            this.field.numeric(type);
            this.field.precisionStep(atts.getValue("precision-step"));
        }
        this._isField = true;
    }

    private void endFieldElement() {
        try {
            this.field.value(this._value.toString());
            if (this._isCompressed) {
                if (this.field.index() != FlintField.IndexOptions.NONE) {
                    this._document.add(this.field);
                }
                this._document.add(this.field.cloneCompressed());
            } else {
                this._document.add(this.field);
            }
        }
        catch (IllegalStateException ex) {
            LOGGER.warn("Unable to create field: " + this.field.name(), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Unable to create field: " + this.field.name(), (Throwable)ex);
        }
        this.field = new FlintField(null);
        this._isField = false;
        this._isCompressed = false;
        this._value.setLength(0);
    }

    private SimpleDateFormat toDateFormat(String format) {
        if (format == null) {
            return null;
        }
        SimpleDateFormat df = this.dfs.get(format);
        if (df == null) {
            try {
                df = new SimpleDateFormat(format);
                if (IndexDocumentHandler_2_0.includesTime(format)) {
                    df.setTimeZone(this._timezone);
                } else {
                    df.setTimeZone(GMT);
                }
                this.dfs.put(format, df);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Ignoring unusable date format '" + format + "'", (Throwable)ex);
            }
        }
        return df;
    }

    private static boolean includesTime(String format) {
        if (format.indexOf(72) >= 0) {
            return true;
        }
        if (format.indexOf(107) >= 0) {
            return true;
        }
        if (format.indexOf(75) >= 0) {
            return true;
        }
        if (format.indexOf(104) >= 0) {
            return true;
        }
        if (format.indexOf(109) >= 0) {
            return true;
        }
        if (format.indexOf(115) >= 0) {
            return true;
        }
        if (format.indexOf(83) >= 0) {
            return true;
        }
        if (format.indexOf(90) >= 0) {
            return true;
        }
        return format.indexOf(122) >= 0;
    }

    private void storeAttribute(String store) {
        if (store != null) {
            switch (store.toLowerCase()) {
                case "true": 
                case "yes": {
                    this.field.store(true);
                    break;
                }
                case "false": 
                case "no": {
                    this.field.store(false);
                }
            }
        }
    }

    private void indexAttribute(String index) {
        if (index != null) {
            switch (index.toLowerCase()) {
                case "analyzed": {
                    this.field.index(FlintField.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS).omitNorms(false).tokenize(true);
                    break;
                }
                case "not-analyzed": {
                    this.field.index(FlintField.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS).omitNorms(false).tokenize(false);
                    break;
                }
                case "analyzed-no-norms": {
                    this.field.index(FlintField.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS).omitNorms(true).tokenize(true);
                    break;
                }
                case "not-analyzed-no-norms": {
                    this.field.index(FlintField.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS).omitNorms(true).tokenize(false);
                    break;
                }
                case "no": {
                    this.field.index(FlintField.IndexOptions.NONE).omitNorms(true);
                    break;
                }
                default: {
                    LOGGER.warn("Invalid field index value: {}", (Object)index);
                }
            }
        }
    }

    private void termVectorAttribute(String vector) {
        if (vector != null) {
            switch (vector.toLowerCase()) {
                case "yes": {
                    this.field.termVector(true).termVectorOffsets(false).termVectorPositions(false);
                }
                case "with-offset": {
                    this.field.termVector(true).termVectorOffsets(true).termVectorPositions(false);
                }
                case "with-positions": {
                    this.field.termVector(true).termVectorOffsets(false).termVectorPositions(true);
                }
                case "with-positions-offsets": {
                    this.field.termVector(true).termVectorOffsets(true).termVectorPositions(true);
                }
                case "no": {
                    this.field.termVector(false).termVectorOffsets(false).termVectorPositions(false);
                }
            }
            LOGGER.warn("Invalid term vector value: {}", (Object)vector);
        }
    }
}

