/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint;

import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenIndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIndexManager.class);
    private static final Comparator<IndexIO> OPEN_INDEX_COMPARATOR = new Comparator<IndexIO>(){

        @Override
        public int compare(IndexIO o1, IndexIO o2) {
            return o1.getLastTimeUsed() < o2.getLastTimeUsed() ? 1 : (o1.getLastTimeUsed() == o2.getLastTimeUsed() ? 0 : -1);
        }
    };
    private static final ConcurrentHashMap<Integer, IndexIO> OPEN_INDEXES = new ConcurrentHashMap();
    private static int maxOpenedIndexes = 100;
    private static long DELAY_BETWEEN_CHECKS = 1800000L;
    private static long LAST_CHECK = 0L;

    private OpenIndexManager() {
    }

    public static void setMaxOpenedIndexes(int val) {
        maxOpenedIndexes = val;
    }

    public static void closeOldReaders() {
        if (System.currentTimeMillis() - LAST_CHECK > DELAY_BETWEEN_CHECKS) {
            LAST_CHECK = System.currentTimeMillis();
            while (OPEN_INDEXES.size() > maxOpenedIndexes) {
                IndexIO or = Collections.max(OPEN_INDEXES.values(), OPEN_INDEX_COMPARATOR);
                try {
                    LOGGER.debug("Closing IO for index {}", (Object)or.hashCode());
                    or.stop();
                }
                catch (IndexException ex) {
                    LOGGER.error("Failed closing an opened index {}", (Object)or.hashCode());
                }
            }
        }
    }

    public static void add(IndexIO index) {
        LOGGER.debug("Adding new index {}", (Object)index.hashCode());
        OPEN_INDEXES.put(index.hashCode(), index);
    }

    public static void remove(IndexIO index) {
        if (OPEN_INDEXES.remove(index.hashCode()) != null) {
            LOGGER.debug("Removing index {}", (Object)index.hashCode());
        }
    }
}

