/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint;

import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.stream.StreamResult;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.Requester;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentFetcher;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.flint.content.ContentTranslatorFactory;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.FlintTranslatorFactory;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexJobQueue;
import org.pageseeder.flint.indexing.IndexListener;
import org.pageseeder.flint.indexing.IndexingThread;
import org.pageseeder.flint.ixml.IndexParser;
import org.pageseeder.flint.ixml.IndexParserFactory;
import org.pageseeder.flint.log.NoOpListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexManager.class);
    private static final int NB_INDEXING_THREADS = 10;
    private final IndexListener _listener;
    private final ContentFetcher _fetcher;
    private final IndexJobQueue _indexQueue;
    private static final ConcurrentHashMap<String, Index> ALL_INDEXES = new ConcurrentHashMap(100, 0.75f, 11);
    private final ConcurrentHashMap<String, ContentTranslatorFactory> translatorFactories;
    private int threadPriority = 5;
    private ExecutorService multiThreadExecutor = null;
    private ExecutorService singleThreadExecutor = null;
    private ContentTranslator _defaultTranslator = null;

    public IndexManager(ContentFetcher cf) {
        this(cf, NoOpListener.getInstance());
    }

    public IndexManager(ContentFetcher cf, IndexListener listener) {
        this(cf, listener, 10, false);
    }

    public IndexManager(ContentFetcher cf, IndexListener listener, int nbThreads, boolean withSingleThread) {
        this._fetcher = cf;
        this._listener = listener;
        this._indexQueue = new IndexJobQueue(withSingleThread);
        this.translatorFactories = new ConcurrentHashMap(16, 0.8f, 2);
        this.registerTranslatorFactory(new FlintTranslatorFactory());
        this.multiThreadExecutor = Executors.newFixedThreadPool(nbThreads, new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "indexing-p" + IndexManager.this.threadPriority + "-t" + this.threadCount++);
                t.setPriority(IndexManager.this.threadPriority);
                return t;
            }
        });
        if (withSingleThread) {
            this.singleThreadExecutor = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r, "indexing-p" + this.threadPriority + "-single");
                t.setPriority(this.threadPriority);
                return t;
            });
        }
    }

    public void setDefaultTranslator(ContentTranslator translator) {
        this._defaultTranslator = translator;
    }

    public void setThreadPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IndexOutOfBoundsException("Thread priority is should be between 1 and 10 but was " + priority);
        }
        this.threadPriority = priority;
    }

    public void registerTranslatorFactory(ContentTranslatorFactory factory) {
        Collection<String> types = factory.getMimeTypesSupported();
        for (String type : types) {
            this.registerTranslatorFactory(type, factory);
        }
    }

    public void registerTranslatorFactory(String mimeType, ContentTranslatorFactory factory) {
        this.translatorFactories.put(mimeType, factory);
    }

    public void indexBatch(IndexBatch batch, String contentid, ContentType type, Index i, Requester r, IndexJob.Priority p, Map<String, String> params) {
        this.indexBatch(batch, contentid, type, i, r, p, false, params);
    }

    public void indexBatch(IndexBatch batch, String contentid, ContentType type, Index i, Requester r, IndexJob.Priority p, boolean singleThread, Map<String, String> params) {
        this.indexJob(IndexJob.newBatchJob(batch, contentid, type, i, p, r, params), singleThread);
    }

    public void indexBatch(Map<String, ContentType> contents, Index i, Requester r, IndexJob.Priority p) {
        IndexBatch batch = new IndexBatch(i.getIndexID(), contents.size());
        for (String key : contents.keySet()) {
            this.indexJob(IndexJob.newBatchJob(batch, key, contents.get(key), i, p, r, null), false);
        }
    }

    public void index(String contentid, ContentType type, Index i, Requester r, IndexJob.Priority p, boolean singleThread, Map<String, String> params) {
        this.indexJob(IndexJob.newJob(contentid, type, i, p, r, params), singleThread);
    }

    public void index(String contentid, ContentType type, Index i, Requester r, IndexJob.Priority p, Map<String, String> params) {
        this.index(contentid, type, i, r, p, false, params);
    }

    public void clear(Index index, Requester requester, IndexJob.Priority priority) {
        this._indexQueue.clearJobsForIndex(index);
        this.indexJob(IndexJob.newClearJob(index, priority, requester), false);
    }

    public List<IndexJob> getStatus(Requester r) {
        return this._indexQueue.getJobsForRequester(r);
    }

    public List<IndexJob> getStatus(Index i) {
        return this._indexQueue.getJobsForIndex(i);
    }

    public List<IndexJob> getStatus() {
        return this._indexQueue.getAllJobs();
    }

    public void contentToIXML(Index index, Content content, Map<String, String> params, Writer out) throws IndexException {
        IndexingThread.translateContent(this, null, index, content, params, new StreamResult(out));
    }

    public List<FlintDocument> contentToDocuments(Index index, Content content, Map<String, String> params) throws IndexException {
        IndexParser parser = IndexParserFactory.getInstanceForTransformation(null);
        IndexingThread.translateContent(this, null, index, content, params, parser.getResult());
        return parser.getDocuments();
    }

    public void stop() {
        this.stop(5L);
    }

    public void stop(long timeout) {
        this._indexQueue.clear();
        this.multiThreadExecutor.shutdownNow();
        try {
            this.multiThreadExecutor.awaitTermination(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.error("Interrupted while shutting down multiple thread", (Throwable)ex);
        }
        if (this.singleThreadExecutor != null) {
            this.singleThreadExecutor.shutdownNow();
            try {
                this.singleThreadExecutor.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while shutting down single thread", (Throwable)ex);
            }
        }
        for (Index index : ALL_INDEXES.values()) {
            index.close();
        }
    }

    protected static void registerIndex(Index index) {
        ALL_INDEXES.put(index.getIndexID(), index);
    }

    protected static void deregisterIndex(Index index) {
        ALL_INDEXES.remove(index.getIndexID(), index);
    }

    public ContentTranslator getTranslator(String mediatype) throws IndexException {
        ContentTranslator translator;
        if (mediatype == null) {
            throw new NullPointerException("mediatype");
        }
        ContentTranslatorFactory factory = this.translatorFactories.get(mediatype);
        if (factory == null && this._defaultTranslator == null) {
            throw new IndexException("Media Type " + mediatype + " is not supported, no Translator Factory was found and no default Translator was specified.", null);
        }
        ContentTranslator contentTranslator = translator = factory == null ? this._defaultTranslator : factory.createTranslator(mediatype);
        if (translator == null) {
            throw new IndexException("No translator was found for MIME Type " + mediatype + ".", null);
        }
        return translator;
    }

    public Content getContent(IndexJob job) {
        return this._fetcher.getContent(job);
    }

    private void indexJob(IndexJob job, boolean singleThread) {
        if (singleThread && this.singleThreadExecutor != null) {
            this._indexQueue.addSingleThreadJob(job);
            this.singleThreadExecutor.execute(new IndexingThread(this, this._listener, this._indexQueue, true));
        } else {
            this._indexQueue.addMultiThreadJob(job);
            this.multiThreadExecutor.execute(new IndexingThread(this, this._listener, this._indexQueue, false));
        }
    }
}

