/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.pageseeder.flint.lucene.facet.DateFieldFacet;
import org.pageseeder.flint.lucene.facet.DateRangeFacet;
import org.pageseeder.flint.lucene.facet.FlexibleFieldFacet;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.facet.NumericRangeFacet;
import org.pageseeder.flint.lucene.facet.StringFieldFacet;
import org.pageseeder.flint.lucene.facet.StringRangeFacet;
import org.pageseeder.flint.lucene.search.FieldFacet;
import org.pageseeder.flint.lucene.search.Terms;

public final class Facets {
    private Facets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldFacet getFacet(String field, int upTo, Query query, Index index) throws IndexException, IOException {
        FieldFacet facet;
        IndexReader reader = null;
        IndexSearcher searcher = null;
        try {
            reader = LuceneIndexQueries.grabReader(index);
            facet = FieldFacet.newFacet(field, reader);
            searcher = LuceneIndexQueries.grabSearcher(index);
            facet.compute(searcher, query, upTo);
        }
        catch (Throwable throwable) {
            LuceneIndexQueries.releaseQuietly(index, reader);
            LuceneIndexQueries.releaseQuietly(index, searcher);
            throw throwable;
        }
        LuceneIndexQueries.releaseQuietly(index, reader);
        LuceneIndexQueries.releaseQuietly(index, searcher);
        return facet;
    }

    public static List<FieldFacet> getFacets(List<String> fields, int upTo, Query query, Index index) throws IOException, IndexException {
        if (query == null) {
            return Facets.getFacets(fields, upTo, index);
        }
        if (fields == null || fields.isEmpty() || index == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        for (String field : fields) {
            if (field.length() <= 0) continue;
            facets.add(Facets.getFacet(field, upTo, query, index));
        }
        return facets;
    }

    public static List<FieldFacet> getFacets(int maxValues, Index index) throws IOException, IndexException {
        return Facets.getFacets(null, maxValues, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldFacet> getFacets(List<String> fields, int maxValues, Index index) throws IOException, IndexException {
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        IndexReader reader = LuceneIndexQueries.grabReader(index);
        IndexSearcher searcher = LuceneIndexQueries.grabSearcher(index);
        try {
            List<String> loopfields = fields == null ? Terms.fields(reader) : fields;
            for (String field : loopfields) {
                FieldFacet facet;
                if (field.length() <= 0 || field.charAt(0) == '_' || (facet = FieldFacet.newFacet(field, reader, maxValues)) == null) continue;
                facet.compute(searcher, maxValues);
                facets.add(facet);
            }
        }
        finally {
            LuceneIndexQueries.releaseQuietly(index, reader);
            LuceneIndexQueries.releaseQuietly(index, searcher);
        }
        return facets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldFacet> getFacets(List<String> fields, int upTo, Query query, List<Index> indexes) throws IOException, IndexException {
        if (fields == null || fields.isEmpty() || indexes.isEmpty()) {
            return Collections.emptyList();
        }
        if (indexes.size() == 1) {
            return Facets.getFacets(fields, upTo, query, indexes.get(0));
        }
        HashMap<Index, IndexReader> readers = new HashMap<Index, IndexReader>();
        for (Index index : indexes) {
            readers.put(index, LuceneIndexQueries.grabReader(index));
        }
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        try {
            MultiReader multiReader = new MultiReader(readers.values().toArray(new IndexReader[0]));
            IndexSearcher multiSearcher = new IndexSearcher((IndexReader)multiReader);
            for (String field : fields) {
                if (field.length() <= 0) continue;
                FieldFacet facet = FieldFacet.newFacet(field, (IndexReader)multiReader);
                facet.compute(multiSearcher, query, upTo);
                facets.add(facet);
            }
        }
        finally {
            for (Map.Entry entry : readers.entrySet()) {
                LuceneIndexQueries.release((Index)entry.getKey(), (IndexReader)entry.getValue());
            }
        }
        return facets;
    }

    public static List<FieldFacet> getFacets(int maxValues, List<Index> indexes) throws IOException, IndexException {
        return Facets.getFacets(null, maxValues, indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldFacet> getFacets(List<String> fields, int maxValues, List<Index> indexes) throws IOException, IndexException {
        HashMap<Index, IndexReader> readers = new HashMap<Index, IndexReader>();
        for (Index index : indexes) {
            readers.put(index, LuceneIndexQueries.grabReader(index));
        }
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        try {
            MultiReader multiReader = new MultiReader(readers.values().toArray(new IndexReader[0]));
            IndexSearcher multiSearcher = new IndexSearcher((IndexReader)multiReader);
            List<String> loopfields = fields == null ? Terms.fields((IndexReader)multiReader) : fields;
            for (String field : loopfields) {
                FieldFacet facet;
                if (field.length() <= 0 || (facet = FieldFacet.newFacet(field, (IndexReader)multiReader, maxValues)) == null) continue;
                facet.compute(multiSearcher, maxValues);
                facets.add(facet);
            }
        }
        finally {
            for (Map.Entry entry : readers.entrySet()) {
                LuceneIndexQueries.release((Index)entry.getKey(), (IndexReader)entry.getValue());
            }
        }
        return facets;
    }

    public static FlexibleFieldFacet createFacet(String name, Catalog catalog) {
        if (catalog != null && catalog.getNumericType(name) != null) {
            return null;
        }
        if (catalog != null && catalog.getResolution(name) != null) {
            return DateFieldFacet.newFacet(name, LuceneUtils.toResolution(catalog.getResolution(name)));
        }
        return StringFieldFacet.newFacet(name);
    }

    public static FlexibleRangeFacet createRangeFacet(String name, Collection<FlexibleRangeFacet.Range> ranges, Catalog catalog) {
        if (catalog != null && catalog.getNumericType(name) != null) {
            NumericRangeFacet.Builder builder = new NumericRangeFacet.Builder().name(name).numeric(catalog.getNumericType(name));
            for (FlexibleRangeFacet.Range range : ranges) {
                builder.addRange(range);
            }
            return builder.build();
        }
        if (catalog != null && catalog.getResolution(name) != null) {
            DateRangeFacet.Builder builder = new DateRangeFacet.Builder().name(name).resolution(LuceneUtils.toResolution(catalog.getResolution(name)));
            for (FlexibleRangeFacet.Range range : ranges) {
                builder.addRange(range);
            }
            return builder.build();
        }
        StringRangeFacet.Builder builder = new StringRangeFacet.Builder().name(name);
        for (FlexibleRangeFacet.Range range : ranges) {
            builder.addRange(range);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FlexibleFieldFacet> getFlexibleFacets(List<String> fields, int maxValues, List<Index> indexes) throws IOException {
        HashMap<Index, IndexReader> readers = new HashMap<Index, IndexReader>();
        Catalog catalog = null;
        for (Index index : indexes) {
            if (catalog == null) {
                catalog = Catalogs.getCatalog((String)index.getCatalog());
            }
            readers.put(index, LuceneIndexQueries.grabReader(index));
        }
        ArrayList<FlexibleFieldFacet> facets = new ArrayList<FlexibleFieldFacet>();
        try {
            MultiReader multiReader = new MultiReader(readers.values().toArray(new IndexReader[0]));
            IndexSearcher multiSearcher = new IndexSearcher((IndexReader)multiReader);
            List<String> loopfields = fields == null ? Terms.fields((IndexReader)multiReader) : fields;
            for (String field : loopfields) {
                FlexibleFieldFacet facet;
                if (field.length() <= 0 || (facet = Facets.createFacet(field, catalog)) == null) continue;
                facet.compute(multiSearcher, maxValues);
                facets.add(facet);
            }
        }
        finally {
            for (Map.Entry entry : readers.entrySet()) {
                LuceneIndexQueries.release((Index)entry.getKey(), (IndexReader)entry.getValue());
            }
        }
        return facets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FlexibleFieldFacet> getFlexibleFacets(List<String> fields, int upTo, Query query, List<Index> indexes) throws IOException {
        if (fields == null || fields.isEmpty() || indexes.isEmpty()) {
            return Collections.emptyList();
        }
        if (indexes.size() == 1) {
            return Facets.getFlexibleFacets(fields, upTo, query, indexes.get(0));
        }
        HashMap<Index, IndexReader> readers = new HashMap<Index, IndexReader>();
        Catalog catalog = null;
        for (Index index : indexes) {
            if (catalog == null) {
                catalog = Catalogs.getCatalog((String)index.getCatalog());
            }
            readers.put(index, LuceneIndexQueries.grabReader(index));
        }
        ArrayList<FlexibleFieldFacet> facets = new ArrayList<FlexibleFieldFacet>();
        try {
            MultiReader multiReader = new MultiReader(readers.values().toArray(new IndexReader[0]));
            IndexSearcher multiSearcher = new IndexSearcher((IndexReader)multiReader);
            for (String field : fields) {
                FlexibleFieldFacet facet;
                if (field.length() <= 0 || (facet = Facets.createFacet(field, catalog)) == null) continue;
                facet.compute(multiSearcher, query, upTo);
                facets.add(facet);
            }
        }
        finally {
            for (Map.Entry entry : readers.entrySet()) {
                LuceneIndexQueries.release((Index)entry.getKey(), (IndexReader)entry.getValue());
            }
        }
        return facets;
    }

    public static List<FlexibleFieldFacet> getFlexibleFacets(List<String> fields, int maxValues, Index index) throws IOException {
        return Facets.getFlexibleFacets(fields, maxValues, null, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FlexibleFieldFacet> getFlexibleFacets(List<String> fields, int maxValues, Query query, Index index) throws IOException {
        ArrayList<FlexibleFieldFacet> facets = new ArrayList<FlexibleFieldFacet>();
        Catalog catalog = Catalogs.getCatalog((String)index.getCatalog());
        IndexReader reader = LuceneIndexQueries.grabReader(index);
        IndexSearcher searcher = LuceneIndexQueries.grabSearcher(index);
        try {
            List<String> loopfields = fields == null ? Terms.fields(reader) : fields;
            for (String field : loopfields) {
                FlexibleFieldFacet facet;
                if (field.length() <= 0 || field.charAt(0) == '_' || (facet = Facets.createFacet(field, catalog)) == null) continue;
                if (query == null) {
                    facet.compute(searcher, maxValues);
                } else {
                    facet.compute(searcher, query, maxValues);
                }
                facets.add(facet);
            }
        }
        finally {
            LuceneIndexQueries.releaseQuietly(index, reader);
            LuceneIndexQueries.releaseQuietly(index, searcher);
        }
        return facets;
    }
}

