/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

public final class SearchPaging {
    public static final int DEFAULT_PAGE = 1;
    public static final int DEFAULT_HITS_PER_PAGE = 20;
    private int _page = 1;
    private int _hitsPerPage = 20;

    public SearchPaging() {
    }

    public SearchPaging(int page, int hitsPerPage) {
        this._page = page;
        this._hitsPerPage = hitsPerPage;
    }

    public int getHitsPerPage() {
        return this._hitsPerPage;
    }

    public void setHitsPerPage(int hitsPerPage) {
        this._hitsPerPage = hitsPerPage;
    }

    public int getPage() {
        return this._page;
    }

    public void setPage(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("Pages must be positive natural integers");
        }
        this._page = page;
    }

    public int getFirstHit() {
        if (this._hitsPerPage <= 0) {
            return 1;
        }
        return this._hitsPerPage * (this._page - 1) + 1;
    }

    public int getLastHit(int totalHits) {
        if (this._hitsPerPage <= 0) {
            return totalHits;
        }
        return Math.min(totalHits, this._hitsPerPage * this._page);
    }

    public int getPageCount(int totalHits) {
        if (this._hitsPerPage <= 0) {
            return 1;
        }
        return (totalHits - 1) / this._hitsPerPage + 1;
    }
}

