/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.pageseeder.flint.lucene.util.Dates;

public class FlintDocumentConverter {
    private final Map<String, String> warnings = new HashMap<String, String>();

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public Collection<String> fieldsWithWarnings() {
        return this.warnings.keySet();
    }

    public String getWarning(String field) {
        return this.warnings.get(field);
    }

    public List<Document> convert(List<FlintDocument> fdocs) {
        HashMap<String, FlintField> forCatalog = new HashMap<String, FlintField>();
        ArrayList<Document> docs = new ArrayList<Document>();
        for (FlintDocument fdoc : fdocs) {
            Document doc = new Document();
            for (FlintField field : fdoc.fields()) {
                List<Field> thefields;
                if (Catalogs.updateField((FlintField)field)) {
                    this.warnings.put(field.name(), "field has been updated because of a different definition in the catalog");
                }
                if ((thefields = this.toFields(field, forCatalog)) != null) {
                    for (Field thefield : thefields) {
                        doc.add((IndexableField)thefield);
                    }
                    continue;
                }
                this.warnings.put(field.name(), "field is ignored because it is invalid");
            }
            for (FlintField ff : forCatalog.values()) {
                if (ff.catalog() == null) continue;
                Catalogs.newField((String)ff.catalog(), (FlintField)ff);
            }
            docs.add(doc);
        }
        return docs;
    }

    private List<Field> toFields(FlintField ffield, Map<String, FlintField> forCatalog) {
        List<Field> fields;
        if (ffield.name() == null) {
            throw new IllegalStateException("Unable to build field, field name not set");
        }
        if (ffield.index() == null) {
            throw new IllegalStateException("Unable to build field, field index not set");
        }
        if (ffield.value() == null) {
            throw new IllegalStateException("Unable to build field, field value not set");
        }
        if (ffield.isDocValues()) {
            fields = this.toDocValuesFields(ffield);
            if (fields != null) {
                forCatalog.put(ffield.name(), ffield);
            }
        } else {
            Field main;
            fields = this.toNormalFields(ffield);
            if (fields != null && !fields.isEmpty() && (main = fields.get(0)).fieldType() != null && main.fieldType().indexOptions() != IndexOptions.NONE && !forCatalog.containsKey(ffield.name())) {
                forCatalog.put(ffield.name(), ffield);
            }
        }
        return fields;
    }

    private List<Field> toNormalFields(FlintField ffield) {
        String name = ffield.name();
        String value = ffield.value().toString();
        ArrayList<Field> fields = new ArrayList<Field>();
        if (ffield.numeric() != null) {
            if (ffield.dateformat() != null) {
                Number date = Dates.toNumber(this.toDate(name, value, ffield.dateformat()), LuceneUtils.toResolution(ffield.resolution()));
                if (date != null && date instanceof Long) {
                    fields.add((Field)new LongPoint(ffield.name(), new long[]{date.longValue()}));
                } else if (date != null && date instanceof Integer) {
                    fields.add((Field)new IntPoint(ffield.name(), new int[]{date.intValue()}));
                } else {
                    this.warnings.put(ffield.name(), "ignoring field as it has a date format but no date");
                    return null;
                }
                fields.add((Field)new StoredField(name, value));
            } else {
                try {
                    FloatPoint field = null;
                    switch (ffield.numeric()) {
                        case FLOAT: {
                            field = new FloatPoint(ffield.name(), new float[]{Float.parseFloat(value)});
                            break;
                        }
                        case DOUBLE: {
                            field = new DoublePoint(ffield.name(), new double[]{Double.parseDouble(value)});
                            break;
                        }
                        case INT: {
                            field = new IntPoint(ffield.name(), new int[]{Integer.parseInt(value)});
                            break;
                        }
                        case LONG: {
                            field = new LongPoint(ffield.name(), new long[]{Long.parseLong(value)});
                        }
                    }
                    if (field != null) {
                        fields.add((Field)field);
                        fields.add((Field)new StoredField(name, value));
                    }
                }
                catch (NumberFormatException ex) {
                    this.warnings.put(ffield.name(), "ignoring number field with invalid value '" + value + "'");
                }
            }
        } else if (ffield.dateformat() != null) {
            Date date = value.isEmpty() ? null : this.toDate(name, value, ffield.dateformat());
            fields.add(new Field(ffield.name(), (CharSequence)(date != null ? Dates.toString(date, LuceneUtils.toResolution(ffield.resolution())) : ""), (IndexableFieldType)FlintDocumentConverter.toType(ffield)));
        } else {
            fields.add(new Field(ffield.name(), (CharSequence)value, (IndexableFieldType)FlintDocumentConverter.toType(ffield)));
        }
        return fields;
    }

    /*
     * Unable to fully structure code
     */
    private List<Field> toDocValuesFields(FlintField ffield) {
        name = ffield.name();
        value = ffield.value().toString();
        fields = new ArrayList<Field>();
        switch (1.$SwitchMap$org$pageseeder$flint$indexing$FlintField$DocValuesType[ffield.docValues().ordinal()]) {
            case 1: {
                return null;
            }
            case 2: {
                if (ffield.numeric() == null || ffield.dateformat() == null) ** GOTO lbl27
                date = Dates.toNumber(this.toDate(name, value, ffield.dateformat()), LuceneUtils.toResolution(ffield.resolution()));
                if (date != null && date instanceof Long) {
                    l = Long.parseLong(value);
                    fields.add((Field)new LongPoint(name, new long[]{l}));
                    fields.add((Field)new SortedNumericDocValuesField(name, l));
                } else if (date != null && date instanceof Integer) {
                    i = Integer.parseInt(value);
                    fields.add((Field)new IntPoint(name, new int[]{i}));
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)i));
                } else {
                    this.warnings.put(ffield.name(), "ignoring field as it has a date format but no date");
                    return null;
lbl27:
                    // 1 sources

                    if (ffield.numeric() != null) {
                        fields.addAll(FlintDocumentConverter.toSortedNumericFields(ffield));
                    }
                }
                fields.add((Field)new StoredField(name, value));
                break;
            }
            case 3: 
            case 4: {
                v0 = isSortedSet = ffield.docValues() == FlintField.DocValuesType.SORTED_SET;
                if (ffield.dateformat() != null) {
                    date = Dates.toString(this.toDate(name, value, ffield.dateformat()), LuceneUtils.toResolution(ffield.resolution()));
                    if (date == null) {
                        date = "";
                    }
                    fields.add(new Field(name, (CharSequence)date, (IndexableFieldType)FlintDocumentConverter.toType(ffield)));
                    fields.add((Field)(isSortedSet != false ? new SortedSetDocValuesField(name, new BytesRef((CharSequence)date)) : new SortedDocValuesField(name, new BytesRef((CharSequence)date))));
                    break;
                }
                fields.add(new Field(name, (CharSequence)value, (IndexableFieldType)FlintDocumentConverter.toType(ffield)));
                fields.add((Field)(isSortedSet != false ? new SortedSetDocValuesField(name, new BytesRef(ffield.value())) : new SortedDocValuesField(name, new BytesRef(ffield.value()))));
            }
        }
        return fields;
    }

    private static List<Field> toSortedNumericFields(FlintField ffield) {
        String name = ffield.name();
        ArrayList<Field> fields = new ArrayList<Field>();
        switch (ffield.numeric()) {
            case DOUBLE: {
                double d = Double.parseDouble(ffield.value().toString());
                fields.add((Field)new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong((double)d)));
                fields.add((Field)new DoublePoint(name, new double[]{d}));
                break;
            }
            case FLOAT: {
                float f = Float.parseFloat(ffield.value().toString());
                fields.add((Field)new SortedNumericDocValuesField(name, (long)NumericUtils.floatToSortableInt((float)f)));
                fields.add((Field)new FloatPoint(name, new float[]{f}));
                break;
            }
            case LONG: {
                long l = Long.parseLong(ffield.value().toString());
                fields.add((Field)new SortedNumericDocValuesField(name, l));
                fields.add((Field)new LongPoint(name, new long[]{l}));
                break;
            }
            case INT: {
                int i = Integer.parseInt(ffield.value().toString());
                fields.add((Field)new SortedNumericDocValuesField(name, (long)i));
                fields.add((Field)new IntPoint(name, new int[]{i}));
            }
        }
        return fields;
    }

    private static FieldType toType(FlintField ffield) {
        FieldType type = new FieldType();
        type.setStored(ffield.store());
        type.setTokenized(ffield.tokenize());
        type.setIndexOptions(FlintDocumentConverter.toIndexOptions(ffield.index()));
        if (ffield.index() != FlintField.IndexOptions.NONE) {
            type.setOmitNorms(ffield.omitNorms());
            type.setStoreTermVectors(ffield.termVector());
            type.setStoreTermVectorOffsets(ffield.termVectorOffsets());
            type.setStoreTermVectorPositions(ffield.termVectorPositions());
            type.setStoreTermVectorPayloads(ffield.termVectorPayloads());
        }
        return type;
    }

    private static IndexOptions toIndexOptions(FlintField.IndexOptions options) {
        if (options == null) {
            return null;
        }
        switch (options) {
            case NONE: {
                return IndexOptions.NONE;
            }
            case DOCS: {
                return IndexOptions.DOCS;
            }
            case DOCS_AND_FREQS: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        return null;
    }

    private Date toDate(String name, String value, SimpleDateFormat format) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return format.parse(value);
        }
        catch (ParseException ex) {
            this.warnings.put(name, "ignoring unparseable date '" + value + "' with format '" + format.toPattern() + "'");
            return null;
        }
    }
}

