/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

public final class FieldDocumentChecker
extends SimpleCollector {
    private boolean fieldFound = false;
    private final String field;
    private LeafReaderContext context = null;

    public FieldDocumentChecker(String fieldname) {
        this.field = fieldname;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext ctxt) throws IOException {
        this.context = ctxt;
    }

    public void collect(int doc) {
        if (this.context != null && !this.fieldFound) {
            Document d;
            try {
                d = this.context.reader().document(doc, Collections.singleton(this.field));
            }
            catch (IOException ex) {
                return;
            }
            if (d != null && d.getField(this.field) != null) {
                this.fieldFound = true;
            }
        }
    }

    public boolean fieldFound() {
        return this.fieldFound;
    }
}

