/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class BasicQuery<T extends SearchParameter>
implements SearchQuery {
    private final T _base;
    private final Map<SearchParameter, BooleanClause.Occur> _parameters;
    private volatile Query _query = null;
    private Sort _sort = Sort.RELEVANCE;

    BasicQuery(T base, List<SearchParameter> parameters) throws NullPointerException {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        this._base = base;
        this._parameters = new HashMap<SearchParameter, BooleanClause.Occur>();
        if (parameters != null) {
            for (SearchParameter param : parameters) {
                this._parameters.put(param, BooleanClause.Occur.MUST);
            }
        }
    }

    BasicQuery(T base, Map<SearchParameter, BooleanClause.Occur> parameters) throws NullPointerException {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        this._base = base;
        this._parameters = parameters;
    }

    public final T base() {
        return this._base;
    }

    public final List<SearchParameter> parameters() {
        return new ArrayList<SearchParameter>(this._parameters.keySet());
    }

    public final Map<SearchParameter, BooleanClause.Occur> parametersMap() {
        return this._parameters;
    }

    public void setSort(Sort sort) {
        this._sort = sort;
    }

    @Override
    public final Sort getSort() {
        return this._sort != null ? this._sort : Sort.RELEVANCE;
    }

    @Override
    public final boolean isEmpty() {
        return this._base == null || this._base.isEmpty();
    }

    @Override
    public Query toQuery() {
        if (this._query == null) {
            this._query = BasicQuery.toQuery(this._base, this._parameters);
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("basic-query", true);
        xml.attribute("empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.attribute("query", this._query.toString());
            xml.openElement("base", true);
            this._base.toXML(xml);
            xml.closeElement();
            xml.openElement("parameters", !this.parameters().isEmpty());
            for (SearchParameter p : this.parameters()) {
                p.toXML(xml);
            }
            xml.closeElement();
            xml.openElement("sort", this._sort != Sort.RELEVANCE);
            if (this._sort == Sort.RELEVANCE) {
                xml.attribute("by", "relevance");
            } else {
                xml.attribute("by", "fields");
                for (SortField sf : this._sort.getSort()) {
                    xml.openElement("sortfield");
                    xml.attribute("field", sf.getField());
                    xml.attribute("type", sf.getType().toString().toLowerCase());
                    xml.attribute("reverse", Boolean.toString(sf.getReverse()));
                    xml.closeElement();
                }
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this._base.toString());
        if (this.parameters().size() > 0) {
            s.append(" with (");
            boolean first = true;
            for (SearchParameter p : this._parameters.keySet()) {
                if (!first) {
                    BooleanClause.Occur oc = this._parameters.get(p);
                    s.append(oc == BooleanClause.Occur.MUST ? " and " : (oc == BooleanClause.Occur.MUST_NOT ? " and not " : " or "));
                }
                s.append(p.toString());
                first = false;
            }
            s.append(')');
        }
        return s.toString();
    }

    private static Query toQuery(SearchParameter base, Map<SearchParameter, BooleanClause.Occur> parameters) {
        if (parameters.isEmpty()) {
            return base.toQuery();
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add(base.toQuery(), BooleanClause.Occur.MUST);
        for (SearchParameter p : parameters.keySet()) {
            query.add(p.toQuery(), parameters.get(p));
        }
        return query.build();
    }

    public static <X extends SearchParameter> BasicQuery<X> newBasicQuery(X base) {
        List<SearchParameter> none = Collections.emptyList();
        return new BasicQuery<X>(base, none);
    }

    public static <X extends SearchParameter> BasicQuery<X> newBasicQuery(X base, List<SearchParameter> parameters) {
        List<SearchParameter> unmodifiable = Collections.unmodifiableList(new ArrayList<SearchParameter>(parameters));
        return new BasicQuery<X>(base, unmodifiable);
    }
}

