/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleFacet;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public abstract class FlexibleRangeFacet
extends FlexibleFacet<Range> {
    public static final int DEFAULT_MAX_NUMBER_OF_VALUES = 10;
    protected transient Bucket<Range> bucket;
    protected transient boolean flexible = false;
    protected transient int totalRanges = 0;
    public static final Range OTHER = new Range(null, false, null, false);

    protected FlexibleRangeFacet(String name) {
        super(name);
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            this.totalRanges = 0;
            List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
            Query filtered = base;
            if (filters != null) {
                this.flexible = true;
                for (Filter filter : filters) {
                    if (this._name.equals(filter.name())) continue;
                    filtered = filter.filterQuery(filtered);
                }
            }
            DocumentCounter counter = new DocumentCounter();
            HashMap<Range, Integer> ranges = new HashMap<Range, Integer>();
            for (Term t : terms) {
                Range r = this.findRange(t);
                if (r == null) {
                    r = OTHER;
                }
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                query.add(filtered, BooleanClause.Occur.MUST);
                query.add(this.termToQuery(t), BooleanClause.Occur.MUST);
                searcher.search((Query)query.build(), (Collector)counter);
                int count = counter.getCount();
                if (count > 0) {
                    Integer ec = (Integer)ranges.get(r);
                    ranges.put(r, count + (ec == null ? 0 : ec));
                }
                counter.reset();
            }
            this.totalRanges = ranges.size();
            Bucket<Range> b = new Bucket<Range>(size);
            for (Range r : ranges.keySet()) {
                b.add(r, (Integer)ranges.get(r));
            }
            this.bucket = b;
        }
    }

    public void compute(IndexSearcher searcher, Query base, int size) throws IOException {
        this.compute(searcher, base, null, size);
    }

    public void compute(IndexSearcher searcher, Query base) throws IOException {
        this.compute(searcher, base, null, 10);
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters) throws IOException {
        this.compute(searcher, base, filters, 10);
    }

    protected void compute(IndexSearcher searcher, int size) throws IOException {
        List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
        DocumentCounter counter = new DocumentCounter();
        HashMap<Range, Integer> ranges = new HashMap<Range, Integer>();
        for (Term t : terms) {
            Range r = this.findRange(t);
            if (r == null) {
                r = OTHER;
            }
            searcher.search(this.termToQuery(t), (Collector)counter);
            int count = counter.getCount();
            if (count > 0) {
                Integer ec = (Integer)ranges.get(r);
                ranges.put(r, count + (ec == null ? 0 : ec));
            }
            counter.reset();
        }
        this.totalRanges = ranges.size();
        Bucket<Range> b = new Bucket<Range>(size);
        for (Range r : ranges.keySet()) {
            b.add(r, (Integer)ranges.get(r));
        }
        this.bucket = b;
    }

    protected Query termToQuery(Term t) {
        return new TermQuery(t);
    }

    @Override
    public abstract String getType();

    protected abstract void rangeToXML(Range var1, int var2, XMLWriter var3) throws IOException;

    protected abstract Range findRange(Term var1);

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("facet", true);
        xml.attribute("name", this._name);
        xml.attribute("type", this.getType());
        xml.attribute("flexible", String.valueOf(this.flexible));
        if (!this.flexible) {
            xml.attribute("total-ranges", this.totalRanges);
        }
        if (this.bucket != null) {
            for (Bucket.Entry<Range> e : this.bucket.entrySet()) {
                if (e.item() == OTHER) {
                    xml.openElement("remaining-range");
                    xml.attribute("cardinality", e.count());
                    xml.closeElement();
                    continue;
                }
                this.rangeToXML(e.item(), e.count(), xml);
            }
        }
        xml.closeElement();
    }

    @Override
    public Bucket<Range> getValues() {
        return this.bucket;
    }

    public int getTotalRanges() {
        return this.totalRanges;
    }

    public static boolean isOther(Range range) {
        return range == OTHER;
    }

    public static class Range
    implements Comparable<Range> {
        private final String _min;
        private final String _max;
        private boolean _includeMin;
        private boolean _includeMax;
        private DateTools.Resolution _resolution;

        private Range(String min, boolean withMin, String max, boolean withMax) {
            this(min, withMin, max, withMax, null);
        }

        private Range(String min, boolean withMin, String max, boolean withMax, DateTools.Resolution resolution) {
            this._max = max;
            this._min = min;
            this._includeMin = withMin;
            this._includeMax = withMax;
        }

        public String getMin() {
            return this._min;
        }

        public String getMax() {
            return this._max;
        }

        public String getFormattedMin() {
            return this._resolution != null ? FlexibleFacet.toDateString(this._min, this._resolution) : this._min;
        }

        public String getFormattedMax() {
            return this._resolution != null ? FlexibleFacet.toDateString(this._max, this._resolution) : this._max;
        }

        public boolean includeMax() {
            return this._includeMax;
        }

        public boolean includeMin() {
            return this._includeMin;
        }

        public String toString() {
            return (this._includeMin ? (char)'[' : '{') + this._min + "-" + this._max + (this._includeMax ? (char)']' : '}');
        }

        public boolean equals(Object obj) {
            if (obj instanceof Range) {
                Range r = (Range)obj;
                return (r._min == null && this._min == null || r._min != null && r._min.equals(this._min)) && (r._max == null && this._max == null || r._max != null && r._max.equals(this._max)) && this._includeMin == r._includeMin && this._includeMax == r._includeMax;
            }
            return false;
        }

        public int hashCode() {
            return (this._min != null ? this._min.hashCode() * 13 : 13) + (this._max != null ? this._max.hashCode() * 11 : 11) + (this._includeMin ? 17 : 7) + (this._includeMax ? 5 : 3);
        }

        @Override
        public int compareTo(Range o) {
            if (this._min == null) {
                if (o._min != null) {
                    return -1;
                }
                if (this._max == null) {
                    return -1;
                }
                if (o._max == null) {
                    return 1;
                }
                return this._max.compareTo(o._max);
            }
            if (o._min == null) {
                return 1;
            }
            return this._min.compareTo(o._min);
        }

        public static Range stringRange(String min, String max) {
            return Range.stringRange(min, true, max, true);
        }

        public static Range stringRange(String min, boolean withMin, String max, boolean withMax) {
            return new Range(min, withMin, max, withMax);
        }

        public static Range numericRange(Number min, Number ma) {
            return Range.numericRange(min, true, ma, true);
        }

        public static Range numericRange(Number min, boolean withMin, Number ma, boolean withMax) {
            return new Range(min == null ? null : min.toString(), withMin, ma == null ? null : ma.toString(), withMax);
        }

        public static Range dateRange(Date min, Date max, DateTools.Resolution res) {
            return Range.dateRange(min, true, max, true, res);
        }

        public static Range dateRange(Date min, boolean withMin, Date max, boolean withMax, DateTools.Resolution res) {
            return new Range(Dates.toString(min, res), withMin, Dates.toString(max, res), withMax, res);
        }
    }
}

