/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.ReaderManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.IndexOpenException;
import org.pageseeder.flint.OpenIndexManager;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexListener;
import org.pageseeder.flint.lucene.LuceneDeleteRule;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LuceneIndexIO
implements IndexIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexIO.class);
    public static final String LAST_COMMIT_DATE = "lastCommitDate";
    private volatile State state = State.CLEAN;
    private final AtomicLong lastTimeUsed = new AtomicLong(0L);
    private IndexWriter _writer;
    private ReaderManager _reader;
    private final Directory _directory;
    private final Analyzer _analyzer;
    private SearcherManager _searcher;
    private Integer writing = 0;
    private Integer committing = 0;
    private final Object lock = new Object();
    private static final SearcherFactory FACTORY = new SearcherFactory();

    public LuceneIndexIO(Directory dir, Analyzer analyzer) throws IndexException {
        this._analyzer = analyzer;
        this._directory = dir;
        this.open();
        try {
            String lastCommitDate;
            List commits = DirectoryReader.listCommits((Directory)dir);
            if (!commits.isEmpty() && (lastCommitDate = (String)((IndexCommit)commits.get(commits.size() - 1)).getUserData().get(LAST_COMMIT_DATE)) != null) {
                this.lastTimeUsed.set(Long.parseLong(lastCommitDate));
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load last index commit date", (Throwable)ex);
        }
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed.get();
    }

    public boolean isClosed() {
        return this.isState(State.CLOSED);
    }

    public synchronized void stop() throws IndexException {
        if (this._writer == null || this.isClosed() || this.isState(State.CLOSING)) {
            return;
        }
        LOGGER.debug("Stopping IO");
        this.maybeCommit();
        if (this._writer == null || this.isClosed() || this.isState(State.CLOSING)) {
            return;
        }
        this.startClosing();
        try {
            this._writer.close();
            this._searcher.close();
            this._reader.close();
            this.state(State.CLOSED);
            OpenIndexManager.remove((IndexIO)this);
        }
        catch (CorruptIndexException ex) {
            throw new IndexException("Failed to close Index because it is corrupted", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new IndexException("Failed to close Index because of an I/O error", (Exception)ex);
        }
    }

    public synchronized void maybeRefresh() {
        if (this._writer == null || !this._writer.isOpen() || !this.isState(State.DIRTY)) {
            return;
        }
        try {
            LOGGER.debug("Reopen reader and searcher");
            this._reader.maybeRefresh();
            this._searcher.maybeRefresh();
            this.state(State.CLEAN);
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to reopen Index Searcher because of an I/O error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void maybeCommit() {
        if (this._writer == null || this.isState(State.CLOSING) || this.isClosed() || this.committing > 0 || !this._writer.hasDeletions() && !this._writer.hasUncommittedChanges() && !this._writer.hasPendingMerges()) {
            return;
        }
        this.state(State.DIRTY);
        this.maybeRefresh();
        if (this._writer == null || !this._writer.isOpen() || this.committing > 0 || this.isState(State.CLOSING) || this.isClosed()) {
            return;
        }
        this.startCommitting();
        try {
            LOGGER.debug("Committing index changes");
            long now = System.currentTimeMillis();
            HashMap<String, String> commitUserData = new HashMap<String, String>();
            commitUserData.put(LAST_COMMIT_DATE, String.valueOf(now));
            this._writer.setLiveCommitData(commitUserData.entrySet());
            this._writer.commit();
            this.lastTimeUsed.set(now);
        }
        catch (CorruptIndexException ex) {
            LOGGER.error("Failed to commit Index because it is corrupted", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to commit Index because of an I/O error", (Throwable)ex);
        }
        finally {
            this.endCommitting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean clearIndex() throws IndexException {
        block12: {
            if (this._writer == null || this.isState(State.CLOSING)) {
                return false;
            }
            try {
                if (this.isClosed()) {
                    this.open();
                }
                this.startWriting();
                this._writer.deleteAll();
                this.lastTimeUsed.set(System.currentTimeMillis());
                this.state(State.DIRTY);
            }
            catch (Exception ex) {
                if (this._directory == null) break block12;
                try {
                    for (String n : this._directory.listAll()) {
                        try {
                            this._directory.deleteFile(n);
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException ex2) {
                    throw new IndexException("Failed to clear Index", ex);
                }
            }
            finally {
                this.endWriting();
            }
        }
        return true;
    }

    public synchronized boolean deleteDocuments(DeleteRule rule) throws IndexException {
        if (this._writer == null || this.isState(State.CLOSING)) {
            return false;
        }
        if (!(rule instanceof LuceneDeleteRule)) {
            return false;
        }
        LuceneDeleteRule drule = (LuceneDeleteRule)rule;
        try {
            if (this.isClosed()) {
                this.open();
            }
            this.startWriting();
            if (drule.useTerm()) {
                this._writer.deleteDocuments(new Term[]{drule.toTerm()});
            } else {
                this._writer.deleteDocuments(new Query[]{drule.toQuery()});
            }
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state(State.DIRTY);
        }
        catch (IOException ex) {
            throw new IndexException("Failed to clear Index", (Exception)ex);
        }
        finally {
            this.endWriting();
        }
        return true;
    }

    public synchronized boolean updateDocuments(DeleteRule rule, List<FlintDocument> documents, IndexListener listener, IndexJob job) throws IndexException {
        LuceneDeleteRule drule;
        if (this._writer == null || this.isState(State.CLOSING)) {
            return false;
        }
        if (rule == null) {
            drule = null;
        } else {
            if (!(rule instanceof LuceneDeleteRule)) {
                return false;
            }
            drule = (LuceneDeleteRule)rule;
        }
        try {
            if (this.isClosed()) {
                this.open();
            }
            this.startWriting();
            HashMap<String, String> warnings = new HashMap<String, String>();
            List<Document> docs = LuceneUtils.toDocuments(documents, warnings);
            if (!warnings.isEmpty()) {
                for (String fieldname : warnings.keySet()) {
                    listener.warn(job, "Warning for field '" + fieldname + "': " + (String)warnings.get(fieldname));
                }
            }
            if (rule != null) {
                if (drule.useTerm()) {
                    this._writer.updateDocuments(drule.toTerm(), docs);
                } else {
                    this._writer.deleteDocuments(new Query[]{drule.toQuery()});
                    this._writer.addDocuments(docs);
                }
            } else {
                this._writer.addDocuments(docs);
            }
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state(State.DIRTY);
        }
        catch (IOException e) {
            throw new IndexException("Failed to update document in Index because of an I/O error", (Exception)e);
        }
        finally {
            this.endWriting();
        }
        return true;
    }

    public synchronized boolean updateDocValues(Term term, Field ... newFields) throws IndexException {
        if (this._writer == null || this.isState(State.CLOSING)) {
            return false;
        }
        try {
            if (this.isClosed()) {
                this.open();
            }
            this.startWriting();
            this._writer.updateDocValues(term, newFields);
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state(State.DIRTY);
        }
        catch (IOException ex) {
            throw new IndexException("Failed to update docvalues in Index because of an I/O error", (Exception)ex);
        }
        finally {
            this.endWriting();
        }
        return true;
    }

    public synchronized IndexSearcher bookSearcher() {
        while (this.isState(State.CLOSING)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for closing to finish", (Throwable)ex);
            }
        }
        try {
            if (this.isClosed()) {
                this.open();
            }
            return (IndexSearcher)this._searcher.acquire();
        }
        catch (IOException | IndexException ex) {
            LOGGER.error("Failed to book searcher", ex);
            return null;
        }
    }

    public void releaseSearcher(IndexSearcher searcher) {
        if (this.isClosed() || this.isState(State.CLOSING)) {
            return;
        }
        try {
            this._searcher.release((Object)searcher);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to release searcher", (Throwable)ex);
        }
    }

    public synchronized IndexReader bookReader() {
        while (this.isState(State.CLOSING)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for closing to finish", (Throwable)ex);
            }
        }
        try {
            if (this.isClosed()) {
                this.open();
            }
            return (IndexReader)this._reader.acquire();
        }
        catch (IOException | IndexException ex) {
            LOGGER.error("Failed to book reader", ex);
            return null;
        }
    }

    public void releaseReader(IndexReader reader) {
        if (this.isClosed() || this.isState(State.CLOSING)) {
            return;
        }
        if (!(reader instanceof DirectoryReader)) {
            throw new IllegalArgumentException("Reader must be a DirectoryReader");
        }
        try {
            this._reader.release((Object)((DirectoryReader)reader));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to release reader", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void state(State s) {
        Object object = this.lock;
        synchronized (object) {
            this.state = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isState(State s) {
        Object object = this.lock;
        synchronized (object) {
            return this.state == s;
        }
    }

    private void startClosing() {
        this.state(State.CLOSING);
        while (this.writing > 0 || this.committing > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for writing to finish", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommitting() {
        while (this.writing > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for writing to finish", (Throwable)ex);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            Integer n = this.committing;
            Integer n2 = this.committing = Integer.valueOf(this.committing + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endCommitting() {
        Object object = this.lock;
        synchronized (object) {
            Integer n = this.committing;
            Integer n2 = this.committing = Integer.valueOf(this.committing - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriting() {
        while (this.committing > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for commit to finish", (Throwable)ex);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            Integer n = this.writing;
            Integer n2 = this.writing = Integer.valueOf(this.writing + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWriting() {
        Object object = this.lock;
        synchronized (object) {
            Integer n = this.writing;
            Integer n2 = this.writing = Integer.valueOf(this.writing - 1);
        }
    }

    private void open() throws IndexException {
        this.open(true);
    }

    private void open(boolean firsttime) throws IndexException {
        try {
            boolean createIt = !DirectoryReader.indexExists((Directory)this._directory);
            boolean readonly = LuceneIndexIO.isReadOnly(this._directory);
            if (readonly) {
                this._writer = null;
                this._reader = new ReaderManager(this._directory);
                this._searcher = new SearcherManager(this._directory, FACTORY);
            } else {
                IndexWriterConfig config = new IndexWriterConfig(this._analyzer);
                ConcurrentMergeScheduler merger = new ConcurrentMergeScheduler();
                config.setMergeScheduler((MergeScheduler)merger);
                if (createIt) {
                    config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                }
                this._writer = new IndexWriter(this._directory, config);
                if (createIt) {
                    this._writer.commit();
                }
                boolean applyAllDeletes = true;
                boolean writeAllDeletes = false;
                this._searcher = new SearcherManager(this._writer, applyAllDeletes, writeAllDeletes, FACTORY);
                this._reader = new ReaderManager(this._writer, applyAllDeletes, writeAllDeletes);
            }
            OpenIndexManager.add((IndexIO)this);
            this.state(State.CLEAN);
        }
        catch (IndexFormatTooOldException ex) {
            if (firsttime) {
                if (this._directory != null) {
                    try {
                        for (String n : this._directory.listAll()) {
                            this._directory.deleteFile(n);
                        }
                    }
                    catch (IOException ex2) {
                        throw new IndexException("Failed to delete index files from old index", (Exception)((Object)ex));
                    }
                }
                this.open(false);
            }
            throw new IndexOpenException("Failed to create index: format is too old!", (Exception)((Object)ex));
        }
        catch (LockObtainFailedException ex) {
            throw new IndexOpenException("Failed to create index: there's already a writer on this index", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new IndexException("Failed to create writer on index", (Exception)ex);
        }
    }

    private static boolean isReadOnly(Directory directory) {
        if (!(directory instanceof FSDirectory)) {
            return false;
        }
        try {
            File f = ((FSDirectory)directory).getDirectory().toFile();
            if (!f.canWrite()) {
                return true;
            }
            File[] files = f.listFiles();
            if (files == null) {
                return true;
            }
            for (File tf : files) {
                if (tf.canWrite()) continue;
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Index is readonly", (Throwable)ex);
            return true;
        }
        return false;
    }

    private static enum State {
        CLEAN,
        DIRTY,
        CLOSING,
        CLOSED;

    }
}

