/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.lucene.document.DateTools;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Dates {
    private static final String ISO8601_DATETIME = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final int ONE_SECOND_IN_MS = 1000;
    private static final int ONE_MINUTE_IN_MS = 60000;
    private static final int ONE_HOUR_IN_MS = 3600000;
    private static final DateFormat ISO_DATETIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    private Dates() {
    }

    public static synchronized String toISODateTime(String value, int offset) throws ParseException {
        int x = Dates.findNonDigitCharacter(value);
        if (x != -1) {
            throw new ParseException("Value is not a valid Lucene date", x);
        }
        Date date = DateTools.stringToDate((String)value);
        TimeZone tz = TimeZone.getDefault();
        int rawOffset = tz.inDaylightTime(date) ? offset - 3600000 : offset;
        tz.setRawOffset(rawOffset);
        ISO_DATETIME.setTimeZone(tz);
        String formatted = ISO_DATETIME.format(date);
        return formatted.substring(0, formatted.length() - 2) + ":" + formatted.substring(formatted.length() - 2);
    }

    public static String toISODate(String value) throws ParseException {
        int x = Dates.findNonDigitCharacter(value);
        if (x != -1) {
            throw new ParseException("Value is not a valid Lucene date", x);
        }
        if ("0".equals(value)) {
            return "";
        }
        int length = value.length();
        switch (length) {
            case 4: {
                return value;
            }
            case 6: {
                return value.substring(0, 4) + "-" + value.substring(4);
            }
            case 8: {
                return value.substring(0, 4) + "-" + value.substring(4, 6) + "-" + value.substring(6);
            }
        }
        throw new ParseException("Value is not a valid Lucene date", 0);
    }

    public static boolean isLuceneDate(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        int length = value.length();
        switch (length) {
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                return Dates.findNonDigitCharacter(value) == -1;
            }
        }
        return false;
    }

    public static String format(Date date, DateTools.Resolution resolution) {
        if (date == null) {
            return null;
        }
        return Dates.format(date.getTime(), resolution);
    }

    public static String format(OffsetDateTime date, DateTools.Resolution resolution) {
        if (date == null) {
            return null;
        }
        return Dates.format(date.toInstant().toEpochMilli(), resolution);
    }

    public static String toString(Date date, DateTools.Resolution resolution) {
        if (date == null) {
            return null;
        }
        return DateTools.timeToString((long)date.getTime(), (DateTools.Resolution)resolution);
    }

    public static String toString(OffsetDateTime date, DateTools.Resolution resolution) {
        if (date == null) {
            return null;
        }
        return DateTools.timeToString((long)date.toInstant().toEpochMilli(), (DateTools.Resolution)resolution);
    }

    public static String toString(Instant date, DateTools.Resolution resolution) {
        if (date == null) {
            return null;
        }
        return DateTools.timeToString((long)date.toEpochMilli(), (DateTools.Resolution)resolution);
    }

    public static Number toNumber(Date date, DateTools.Resolution resolution) {
        if (date == null) {
            return null;
        }
        return Dates.toNumber(date.getTime(), resolution);
    }

    public static Number toNumber(OffsetDateTime date, DateTools.Resolution resolution) {
        if (date == null) {
            return null;
        }
        return Dates.toNumber(date.toInstant().toEpochMilli(), resolution);
    }

    public static void dateRangeToXML(String element, String min, String max, boolean withMin, boolean withMax, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement(element);
        if (min != null) {
            xml.attribute("min", min);
        }
        if (max != null) {
            xml.attribute("max", max);
        }
        if (min != null) {
            xml.attribute("include-min", withMin ? "true" : "false");
        }
        if (max != null) {
            xml.attribute("include-max", withMax ? "true" : "false");
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    public static String format(long timems, DateTools.Resolution resolution) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(timems);
        StringBuilder iso = new StringBuilder();
        iso.append(Dates.leftZeroPad4(calendar.get(1)));
        if (resolution == DateTools.Resolution.YEAR) {
            return iso.toString();
        }
        iso.append('-').append(Dates.leftZeroPad2(calendar.get(2) + 1));
        if (resolution == DateTools.Resolution.MONTH) {
            return iso.toString();
        }
        iso.append('-').append(Dates.leftZeroPad2(calendar.get(5)));
        if (resolution == DateTools.Resolution.DAY) {
            return iso.toString();
        }
        String z = Dates.toTimeZone(calendar.getTimeZone().getOffset(timems));
        iso.append('T').append(Dates.leftZeroPad2(calendar.get(11)));
        if (resolution == DateTools.Resolution.HOUR) {
            return iso.append(z).toString();
        }
        iso.append(':').append(Dates.leftZeroPad2(calendar.get(12)));
        if (resolution == DateTools.Resolution.MINUTE) {
            return iso.append(z).toString();
        }
        iso.append(':').append(Dates.leftZeroPad2(calendar.get(13)));
        if (resolution == DateTools.Resolution.SECOND) {
            return iso.append(z).toString();
        }
        iso.append('.').append(Dates.leftZeroPad3(calendar.get(14)));
        return iso.append(z).toString();
    }

    private static Number toNumber(long timems, DateTools.Resolution resolution) {
        if (resolution == DateTools.Resolution.MILLISECOND) {
            return timems;
        }
        if (resolution == DateTools.Resolution.SECOND) {
            return timems / 1000L;
        }
        if (resolution == DateTools.Resolution.MINUTE) {
            return timems / 60000L;
        }
        if (resolution == DateTools.Resolution.HOUR) {
            return timems / 3600000L;
        }
        Calendar c = GregorianCalendar.getInstance();
        c.setTimeInMillis(timems);
        if (resolution == DateTools.Resolution.DAY) {
            return c.get(1) * 10000 + (c.get(2) + 1) * 100 + c.get(5);
        }
        if (resolution == DateTools.Resolution.MONTH) {
            return c.get(1) * 100 + c.get(2) + 1;
        }
        if (resolution == DateTools.Resolution.YEAR) {
            return c.get(1);
        }
        return null;
    }

    private static String leftZeroPad2(int value) {
        return value < 10 ? "0" + Integer.toString(value) : Integer.toString(value);
    }

    private static String leftZeroPad3(int value) {
        if (value >= 100) {
            return Integer.toString(value);
        }
        if (value >= 10) {
            return "0" + Integer.toString(value);
        }
        return "00" + Integer.toString(value);
    }

    private static String leftZeroPad4(int value) {
        if (value >= 1000) {
            return Integer.toString(value);
        }
        if (value >= 100) {
            return "0" + Integer.toString(value);
        }
        if (value >= 10) {
            return "00" + Integer.toString(value);
        }
        return "000" + Integer.toString(value);
    }

    private static String toTimeZone(int offset) {
        if (offset == 0) {
            return "Z";
        }
        int _offset = offset;
        StringBuilder z = new StringBuilder(6);
        z.append(_offset >= 0 ? (char)'+' : '-');
        if (_offset < 0) {
            _offset *= -1;
        }
        z.append(Dates.leftZeroPad2(_offset / 3600000)).append(':').append(Dates.leftZeroPad2(_offset / 60000 % 60));
        return z.toString();
    }

    private static int findNonDigitCharacter(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return i;
        }
        return -1;
    }
}

