/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.query.NumberParameter;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.TermFilter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class NumericTermFilter
extends TermFilter<Number>
implements Filter {
    private FlintField.NumericType _numeric;

    private NumericTermFilter(Builder builder) {
        super(builder._name, builder._values);
        this._numeric = builder._numeric;
    }

    public FlintField.NumericType getNumericType() {
        return this._numeric;
    }

    @Override
    public Query filterQuery(Query base) {
        if (this._terms.values().contains(BooleanClause.Occur.SHOULD)) {
            BooleanQuery.Builder filterQuery = new BooleanQuery.Builder();
            for (Number value : this._terms.keySet()) {
                filterQuery.add(this.numberToQuery(value), (BooleanClause.Occur)this._terms.get(value));
            }
            return base == null ? filterQuery.build() : Queries.and(new Query[]{base, filterQuery.build()});
        }
        BooleanQuery.Builder filterQuery = new BooleanQuery.Builder();
        if (base != null) {
            filterQuery.add(base, BooleanClause.Occur.MUST);
        }
        for (Number value : this._terms.keySet()) {
            filterQuery.add(this.numberToQuery(value), (BooleanClause.Occur)this._terms.get(value));
        }
        return filterQuery.build();
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("filter");
        xml.attribute("field", this._name);
        xml.attribute("type", "numeric");
        for (Number value : this._terms.keySet()) {
            xml.openElement("term");
            xml.attribute("text", String.valueOf(value));
            xml.attribute("occur", NumericTermFilter.occurToString((BooleanClause.Occur)this._terms.get(value)));
            xml.closeElement();
        }
        xml.closeElement();
    }

    public static NumericTermFilter newFilter(String name, Number value) {
        return NumericTermFilter.newFilter(name, value, BooleanClause.Occur.MUST);
    }

    public static NumericTermFilter newFilter(String name, Number value, BooleanClause.Occur occur) {
        FlintField.NumericType numeric;
        if (value instanceof Integer) {
            numeric = FlintField.NumericType.INT;
        } else if (value instanceof Float) {
            numeric = FlintField.NumericType.FLOAT;
        } else if (value instanceof Double) {
            numeric = FlintField.NumericType.DOUBLE;
        } else if (value instanceof Long) {
            numeric = FlintField.NumericType.LONG;
        } else {
            return null;
        }
        return new Builder().name(name).numeric(numeric).addNumber(value, occur).build();
    }

    private Query numberToQuery(Number value) {
        switch (this._numeric) {
            case INT: {
                return NumberParameter.newIntParameter(this._name, (Integer)value).toQuery();
            }
            case LONG: {
                return NumberParameter.newLongParameter(this._name, (Long)value).toQuery();
            }
            case DOUBLE: {
                return NumberParameter.newDoubleParameter(this._name, NumericUtils.sortableLongToDouble((long)((Long)value))).toQuery();
            }
            case FLOAT: {
                return NumberParameter.newFloatParameter(this._name, Float.valueOf(NumericUtils.sortableIntToFloat((int)((Integer)value)))).toQuery();
            }
        }
        return null;
    }

    public static class Builder {
        private String _name = null;
        private FlintField.NumericType _numeric = null;
        private final Map<Number, BooleanClause.Occur> _values = new HashMap<Number, BooleanClause.Occur>();

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder numeric(FlintField.NumericType numeric) {
            this._numeric = numeric;
            return this;
        }

        public Builder addNumber(Number value, BooleanClause.Occur when) {
            this._values.put(value, when == null ? BooleanClause.Occur.MUST : when);
            return this;
        }

        public NumericTermFilter build() {
            if (this._name == null) {
                throw new IllegalStateException("name");
            }
            if (this._numeric == null) {
                throw new IllegalStateException("numeric");
            }
            if (this._values.isEmpty()) {
                throw new IllegalStateException("no values to filter with!");
            }
            return new NumericTermFilter(this);
        }
    }
}

