/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.pageseeder.flint.lucene.util.Beta;

public final class Fields {
    private Fields() {
    }

    @Beta
    public static Map<String, Float> asBoostMap(List<String> fields) {
        LinkedHashMap<String, Float> map = new LinkedHashMap<String, Float>();
        for (String f : fields) {
            map.put(f, Float.valueOf(1.0f));
        }
        return map;
    }

    @Beta
    public static boolean isValidName(String field) {
        return field != null && field.length() > 0;
    }

    @Beta
    public static List<String> filterNames(List<String> fields) {
        ArrayList<String> names = new ArrayList<String>();
        for (String f : fields) {
            if (!Fields.isValidName(f)) continue;
            names.add(f);
        }
        return names;
    }

    @Beta
    public static List<String> toValues(String text) {
        ArrayList<String> values = new ArrayList<String>();
        Pattern p = Pattern.compile("(\\\"[^\\\"]+\\\")|(\\S+)");
        Matcher m = p.matcher(text);
        while (m.find()) {
            values.add(m.group());
        }
        return values;
    }

    public static String toString(IndexableField f) {
        BytesRef binary;
        if (f == null) {
            return null;
        }
        String value = f.stringValue();
        if (value == null && (binary = f.binaryValue()) != null) {
            value = binary.utf8ToString();
        }
        return value;
    }

    public static List<String> toTerms(String field, String text, Analyzer analyzer) {
        ArrayList<String> terms = new ArrayList<String>();
        try {
            TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(text));
            CharTermAttribute attribute = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                String term = attribute.toString();
                terms.add(term);
            }
            stream.end();
            stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return terms;
    }
}

