/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.util;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Highlighter {
    private static final Logger LOGGER = LoggerFactory.getLogger(org.apache.lucene.search.highlight.Highlighter.class);
    private final Query _query;
    private final IndexReader _reader;
    private final Analyzer _analyzer;
    private String markerName = "term";

    public Highlighter(Query query, Analyzer analyzer) {
        this(query, null, analyzer);
    }

    public Highlighter(Query query, IndexReader reader, Analyzer analyzer) {
        this._query = query;
        this._reader = reader;
        this._analyzer = analyzer;
    }

    public void setMarkerTag(String name) {
        this.markerName = name;
    }

    public String highlight(String field, String text, int length) {
        try {
            String h = this.createHighlighter(field, length).getBestFragment(this._analyzer, field, text);
            return h == null ? null : h.trim();
        }
        catch (IOException | InvalidTokenOffsetsException ex) {
            LOGGER.error("Failed to highlight content for field {}", (Object)field, (Object)ex);
            return null;
        }
    }

    public String[] highlights(String field, String text, int nbHighlihghts, int length) {
        try {
            return this.createHighlighter(field, length).getBestFragments(this._analyzer, field, text, nbHighlihghts);
        }
        catch (IOException | InvalidTokenOffsetsException ex) {
            LOGGER.error("Failed to highlight content for field {}", (Object)field, (Object)ex);
            return null;
        }
    }

    private org.apache.lucene.search.highlight.Highlighter createHighlighter(String field, int length) {
        QueryScorer scorer = new QueryScorer(this._query, this._reader, field);
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<" + this.markerName + ">", "</" + this.markerName + ">");
        org.apache.lucene.search.highlight.Highlighter highlighter = new org.apache.lucene.search.highlight.Highlighter((Formatter)formatter, (Scorer)scorer);
        highlighter.setTextFragmenter((Fragmenter)new SimpleSpanFragmenter(scorer, length));
        highlighter.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
        return highlighter;
    }
}

