/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class SuggestionQuery
implements SearchQuery {
    private final List<Term> _terms;
    private final Query _condition;
    private final boolean _unionTermResults;
    private BooleanQuery query = null;
    private boolean tooManyPrefixes = false;

    public SuggestionQuery(List<Term> terms) {
        this(terms, null);
    }

    public SuggestionQuery(List<Term> terms, Query condition) {
        this(terms, condition, true);
    }

    public SuggestionQuery(List<Term> terms, boolean unionTermResults) {
        this(terms, null, unionTermResults);
    }

    public SuggestionQuery(List<Term> terms, Query condition, boolean unionTermResults) {
        this._terms = terms;
        this._condition = condition;
        this._unionTermResults = unionTermResults;
    }

    public void compute(IndexReader reader) throws IOException {
        BooleanQuery mainQuery;
        BooleanQuery booleanQuery = mainQuery = this._unionTermResults ? this.computeORQuery(reader) : this.computeANDQuery(reader);
        if (this._condition == null) {
            this.query = mainQuery;
        } else {
            BooleanQuery.Builder dad = new BooleanQuery.Builder();
            dad.add(this._condition, BooleanClause.Occur.MUST);
            dad.add((Query)mainQuery, BooleanClause.Occur.MUST);
            this.query = dad.build();
        }
    }

    public boolean isIncomplete() {
        return this.tooManyPrefixes;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("suggestion-query");
        if (this.tooManyPrefixes) {
            xml.attribute("incomplete", "true");
        }
        xml.openElement("terms");
        for (Term t : this._terms) {
            xml.openElement("term");
            xml.attribute("field", t.field());
            xml.attribute("text", t.text());
            xml.closeElement();
        }
        xml.closeElement();
        if (this._condition != null) {
            xml.openElement("condition");
            xml.writeText(this._condition.toString());
            xml.closeElement();
        }
        xml.closeElement();
    }

    @Override
    public Query toQuery() {
        return this.query;
    }

    @Override
    public boolean isEmpty() {
        return this._terms.isEmpty();
    }

    @Override
    public Sort getSort() {
        return Sort.RELEVANCE;
    }

    private BooleanQuery computeORQuery(IndexReader reader) throws IOException {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        try {
            for (Term term : this._terms) {
                List<String> values = Terms.prefix(reader, term);
                for (String v : values) {
                    this.addTermQuery(term, v, builder);
                }
            }
        }
        catch (BooleanQuery.TooManyClauses ex) {
            this.tooManyPrefixes = true;
        }
        return builder.build();
    }

    private BooleanQuery computeANDQuery(IndexReader reader) throws IOException {
        if (this._terms.size() == 1) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            Term only = this._terms.get(0);
            List<String> values = Terms.prefix(reader, only);
            try {
                for (String v : values) {
                    this.addTermQuery(only, v, builder);
                }
            }
            catch (BooleanQuery.TooManyClauses ex) {
                this.tooManyPrefixes = true;
            }
            return builder.build();
        }
        HashMap<String, BooleanQuery.Builder> fieldQueries = new HashMap<String, BooleanQuery.Builder>();
        for (Term term : this._terms) {
            try {
                BooleanQuery.Builder thisTermQuery = new BooleanQuery.Builder();
                List<String> values = Terms.prefix(reader, term);
                for (String v : values) {
                    this.addTermQuery(term, v, thisTermQuery);
                }
                fieldQueries.computeIfAbsent(term.field(), s -> new BooleanQuery.Builder()).add((Query)thisTermQuery.build(), BooleanClause.Occur.MUST);
            }
            catch (BooleanQuery.TooManyClauses ex) {
                this.tooManyPrefixes = true;
            }
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (BooleanQuery.Builder subq : fieldQueries.values()) {
            bq.add((Query)subq.build(), BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    private void addTermQuery(Term original, String value, BooleanQuery.Builder query) throws BooleanQuery.TooManyClauses {
        if (value.equals(original.text())) {
            query.add((Query)new BoostQuery((Query)new TermQuery(original), 2.0f), BooleanClause.Occur.SHOULD);
        } else {
            query.add((Query)new TermQuery(new Term(original.field(), value)), BooleanClause.Occur.SHOULD);
        }
    }
}

