/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompletionQuery
implements SearchQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionQuery.class);
    private final Query _query;
    private final Sort _sort = Sort.RELEVANCE;
    private final List<Term> _terms;

    public CompletionQuery(String input, Collection<String> fields, String predicateFilter, Query filters, Analyzer analyzer) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        CompletionAnalyzer ca = new CompletionAnalyzer(analyzer);
        this._terms = CompletionQuery.toTerms(input, fields, (Analyzer)ca);
        if (this._terms.isEmpty()) {
            throw new IllegalArgumentException("input,fields");
        }
        this._query = CompletionQuery.toQuery(this._terms, CompletionQuery.filtersQuery(predicateFilter, filters, (Analyzer)ca), (Analyzer)ca);
    }

    @Override
    public Sort getSort() {
        return this._sort;
    }

    @Override
    public boolean isEmpty() {
        return this._query == null;
    }

    @Override
    public Query toQuery() {
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("completion-query", true);
        xml.attribute("empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.attribute("query", this._query.toString());
            for (Term t : this._terms) {
                xml.openElement("term");
                xml.attribute("field", t.field());
                xml.attribute("text", t.text());
                xml.closeElement();
            }
        }
        xml.closeElement();
    }

    private static List<Term> toTerms(String input, Collection<String> fields, Analyzer analyzer) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String field : fields) {
            for (String word : Fields.toTerms(field, input, analyzer)) {
                terms.add(new Term(field, word));
            }
        }
        return terms;
    }

    private static Query filtersQuery(String predicate, Query filter, Analyzer analyzer) {
        Query predicateQuery = null;
        if (predicate != null && !predicate.isEmpty()) {
            StandardQueryParser parser = new StandardQueryParser(analyzer);
            parser.setAllowLeadingWildcard(false);
            try {
                predicateQuery = parser.parse(predicate, "pstype");
            }
            catch (Exception ex) {
                LOGGER.error("Unable to parse index predicate", (Throwable)ex);
            }
        }
        if (predicateQuery == null && filter != null) {
            return filter;
        }
        if (filter == null && predicateQuery != null) {
            return predicateQuery;
        }
        if (predicateQuery != null) {
            BooleanQuery.Builder combined = new BooleanQuery.Builder();
            combined.add(filter, BooleanClause.Occur.MUST);
            combined.add(predicateQuery, BooleanClause.Occur.MUST);
            return combined.build();
        }
        return null;
    }

    private static Query toQuery(List<Term> terms, Query filters, Analyzer analyzer) {
        Query query = null;
        return query;
    }
}

