/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.lucene.LuceneIndexIO;
import org.pageseeder.flint.lucene.MultipleIndexReader;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LuceneIndexQueries {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexQueries.class);

    public static SearchResults query(Index index, SearchQuery query) throws IndexException {
        return LuceneIndexQueries.query(index, query, new SearchPaging());
    }

    public static SearchResults query(Index index, SearchQuery query, SearchPaging paging) throws IndexException {
        LuceneIndexIO io = LuceneIndexQueries.getIndexIO(index);
        IndexSearcher searcher = io.bookSearcher();
        if (searcher != null) {
            try {
                Query lquery = query.toQuery();
                if (lquery == null) {
                    io.releaseSearcher(searcher);
                    throw new IndexException("Failed performing a query on the Index because the query is null", (Exception)new NullPointerException("Null query"));
                }
                LOGGER.debug("Performing search [{}] on index {}", (Object)query, (Object)index);
                Sort sort = query.getSort();
                if (sort == null) {
                    sort = Sort.INDEXORDER;
                }
                TopFieldCollector tfc = TopFieldCollector.create((Sort)sort, (int)(paging.getHitsPerPage() * paging.getPage()), (boolean)true, (boolean)true, (boolean)false);
                searcher.search(lquery, (Collector)tfc);
                return new SearchResults(query, tfc.topDocs().scoreDocs, tfc.getTotalHits(), paging, io, searcher);
            }
            catch (IOException e) {
                io.releaseSearcher(searcher);
                throw new IndexException("Failed performing a query on the Index because of an I/O problem", (Exception)e);
            }
        }
        return null;
    }

    public static void query(Index index, Query query, Collector results) throws IndexException {
        LuceneIndexIO io = LuceneIndexQueries.getIndexIO(index);
        IndexSearcher searcher = io.bookSearcher();
        if (searcher != null) {
            try {
                LOGGER.debug("Performing search [{}] on index {}", (Object)query, (Object)index);
                searcher.search(query, results);
            }
            catch (IOException e) {
                throw new IndexException("Failed performing a query on the Index because of an I/O problem", (Exception)e);
            }
            finally {
                io.releaseSearcher(searcher);
            }
        }
    }

    public static SearchResults query(List<Index> indexes, SearchQuery query) throws IndexException {
        return LuceneIndexQueries.query(indexes, query, new SearchPaging());
    }

    public static SearchResults query(List<Index> indexes, SearchQuery query, SearchPaging paging) throws IndexException {
        Query lquery = query.toQuery();
        if (lquery == null) {
            throw new IndexException("Failed performing a query because the query is null", (Exception)new NullPointerException("Null query"));
        }
        HashMap<LuceneIndexIO, IndexReader> readersMap = new HashMap<LuceneIndexIO, IndexReader>();
        IndexReader[] readers = new IndexReader[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            IndexReader reader;
            LuceneIndexIO io = LuceneIndexQueries.getIndexIO(indexes.get(i));
            if (io == null) continue;
            readers[i] = reader = io.bookReader();
            readersMap.put(io, reader);
        }
        try {
            MultiReader reader = new MultiReader(readers);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            LOGGER.debug("Performing search [{}] on {} indexes", (Object)query, (Object)readers.length);
            Sort sort = query.getSort();
            if (sort == null) {
                sort = Sort.INDEXORDER;
            }
            TopFieldDocs results = searcher.search(lquery, paging.getHitsPerPage() * paging.getPage(), sort);
            return new SearchResults(query, results, paging, readersMap, searcher);
        }
        catch (IOException e) {
            for (LuceneIndexIO io : readersMap.keySet()) {
                io.releaseReader((IndexReader)readersMap.get(io));
            }
            throw new IndexException("Failed performing a query on the Index because of an I/O problem", (Exception)e);
        }
    }

    public static MultipleIndexReader getMultipleIndexReader(List<Index> indexes) {
        return new MultipleIndexReader(indexes);
    }

    public static IndexReader grabReader(Index index) throws IndexException {
        if (index == null) {
            throw new NullPointerException("Cannot grab reader from null index");
        }
        LuceneIndexIO io = LuceneIndexQueries.getIndexIO(index);
        if (io == null) {
            LOGGER.error("Failed to  grab reader as the IndexIO is not available");
            return null;
        }
        return io.bookReader();
    }

    public static void release(Index index, IndexReader reader) throws IndexException {
        if (index == null || reader == null) {
            return;
        }
        LuceneIndexIO io = LuceneIndexQueries.getIndexIO(index);
        if (io != null) {
            io.releaseReader(reader);
        }
    }

    public static void releaseQuietly(Index index, IndexReader reader) {
        if (index == null || reader == null) {
            return;
        }
        LuceneIndexIO io = LuceneIndexQueries.getIndexIO(index);
        if (io != null) {
            io.releaseReader(reader);
        }
    }

    public static IndexSearcher grabSearcher(Index index) throws IndexException {
        if (index == null) {
            throw new NullPointerException("Cannot grab searcher from null index");
        }
        LuceneIndexIO io = LuceneIndexQueries.getIndexIO(index);
        if (io == null) {
            LOGGER.error("Failed to  grab searcher as the IndexIO is not available");
            return null;
        }
        return io.bookSearcher();
    }

    public static void release(Index index, IndexSearcher searcher) throws IndexException {
        if (searcher == null) {
            return;
        }
        LuceneIndexIO io = LuceneIndexQueries.getIndexIO(index);
        io.releaseSearcher(searcher);
    }

    public static void releaseQuietly(Index index, IndexSearcher searcher) {
        if (searcher == null) {
            return;
        }
        LuceneIndexQueries.getIndexIO(index).releaseSearcher(searcher);
    }

    private static LuceneIndexIO getIndexIO(Index index) {
        if (index == null) {
            return null;
        }
        IndexIO io = index.getIndexIO();
        if (io instanceof LuceneIndexIO) {
            return (LuceneIndexIO)io;
        }
        return null;
    }
}

