/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;

public final class Queries {
    private static final Pattern IS_A_PHRASE = Pattern.compile("\\\"[^\\\"]+\\\"");

    private Queries() {
    }

    public static Query and(Query ... queries) {
        if (queries.length == 1) {
            return queries[0];
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (Query q : queries) {
            query.add(q, BooleanClause.Occur.MUST);
        }
        return query.build();
    }

    public static Query or(Query ... queries) {
        if (queries.length == 1) {
            return queries[0];
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (Query q : queries) {
            query.add(q, BooleanClause.Occur.SHOULD);
        }
        return query.build();
    }

    public static Query combine(boolean withOR, List<Query> queries) {
        return withOR ? Queries.or(queries.toArray(new Query[0])) : Queries.and(queries.toArray(new Query[0]));
    }

    @Beta
    public static List<Query> similar(Query query, Collection<Term> terms, IndexReader reader) throws IOException {
        ArrayList<Query> similar = new ArrayList<Query>();
        for (Term t : terms) {
            List<String> fuzzy = Terms.fuzzy(reader, t);
            for (String f : fuzzy) {
                Query sq = Queries.substitute(query, t, new Term(t.field(), f));
                similar.add(sq);
            }
        }
        return similar;
    }

    public static boolean isAPhrase(String text) {
        return IS_A_PHRASE.matcher(text).matches();
    }

    public static Query termQuery(String field, String text, boolean supportWildcards) {
        Term t = new Term(field, text);
        return supportWildcards && Queries.hasWildcards(text) ? new WildcardQuery(t) : new TermQuery(t);
    }

    @Beta
    public static Query toTermOrPhraseQuery(String field, String text) {
        return Queries.toTermOrPhraseQuery(field, text, false);
    }

    @Beta
    public static Query toTermOrPhraseQuery(String field, String text, boolean supportWildcards) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        boolean isPhrase = Queries.isAPhrase(text);
        if (isPhrase) {
            String[] terms;
            PhraseQuery.Builder phrase = new PhraseQuery.Builder();
            for (String t : terms = text.substring(1, text.length() - 1).split("\\s+")) {
                phrase.add(new Term(field, t));
            }
            return phrase.build();
        }
        return Queries.termQuery(field, text, supportWildcards);
    }

    @Beta
    public static List<Query> toTermOrPhraseQueries(String field, String text, Analyzer analyzer) {
        return Queries.toTermOrPhraseQueries(field, text, false, analyzer);
    }

    @Beta
    public static List<Query> toTermOrPhraseQueries(String field, String text, boolean supportWildcards, Analyzer analyzer) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (analyzer == null) {
            return Collections.singletonList(Queries.toTermOrPhraseQuery(field, text, supportWildcards));
        }
        boolean isPhrase = Queries.isAPhrase(text);
        if (isPhrase && Queries.isTokenized(field, analyzer)) {
            PhraseQuery.Builder phrase = new PhraseQuery.Builder();
            Queries.addTermsToPhrase(field, text.substring(1, text.length() - 1), analyzer, phrase);
            return Collections.singletonList(phrase.build());
        }
        if (supportWildcards && Queries.hasWildcards(text)) {
            if (Queries.isTokenized(field, analyzer)) {
                ArrayList<Query> q = new ArrayList<Query>();
                for (String t : text.split("\\s+")) {
                    q.add(Queries.termQuery(field, t, true));
                }
                return q;
            }
            return Collections.singletonList(Queries.termQuery(field, text, true));
        }
        ArrayList<Query> q = new ArrayList<Query>();
        for (String t : Fields.toTerms(field, text, analyzer)) {
            q.add(Queries.termQuery(field, t, supportWildcards));
        }
        return q;
    }

    @Beta
    public static Query parseToQuery(String field, String text, Analyzer analyzer) {
        return Queries.parseToQuery(field, text, analyzer, true);
    }

    @Beta
    public static Query parseToQuery(String field, String text, Analyzer analyzer, boolean defaultOperatorOR) {
        return Queries.parseToQuery(field, text, analyzer, defaultOperatorOR, false);
    }

    @Beta
    public static Query parseToQuery(String field, String text, Analyzer analyzer, boolean defaultOperatorOR, boolean supportWildcards) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (!text.trim().matches(".*?\\s.*?") || Queries.isAPhrase(text) || analyzer != null && !Queries.isTokenized(field, analyzer) && Queries.hasNoOperators(text)) {
            if (analyzer == null) {
                return Queries.toTermOrPhraseQuery(field, text, supportWildcards);
            }
            return Queries.combine(defaultOperatorOR, Queries.toTermOrPhraseQueries(field, text, supportWildcards, analyzer));
        }
        Query query = null;
        boolean lastIsAND = !defaultOperatorOR;
        Pattern p = Pattern.compile("(\\([^\\(]+\\))|(\\S+)");
        Matcher m = p.matcher(text);
        while (m.find()) {
            Query thisQuery = null;
            String g = m.group().trim();
            if (g.charAt(0) == '(' && g.charAt(g.length() - 1) == ')') {
                thisQuery = Queries.parseToQuery(field, g.substring(1, g.length() - 1), analyzer, true, supportWildcards);
            } else if ("AND".equals(g)) {
                lastIsAND = true;
            } else if ("OR".equals(g)) {
                lastIsAND = false;
            } else if (analyzer == null) {
                thisQuery = Queries.toTermOrPhraseQuery(field, g, supportWildcards);
            } else {
                List<Query> combined = Queries.toTermOrPhraseQueries(field, g, supportWildcards, analyzer);
                if (!combined.isEmpty()) {
                    thisQuery = Queries.combine(defaultOperatorOR, combined);
                }
            }
            if (thisQuery == null) continue;
            query = query == null ? thisQuery : (lastIsAND ? Queries.and(query, thisQuery) : Queries.or(query, thisQuery));
            lastIsAND = !defaultOperatorOR;
        }
        return query;
    }

    public static boolean hasNoOperators(String text) {
        return text != null && !text.contains(" OR ") && !text.contains(" AND ");
    }

    private static void addTermsToPhrase(String field, String text, Analyzer analyzer, PhraseQuery.Builder phrase) {
        try {
            TokenStream stream = analyzer.tokenStream(field, text);
            PositionIncrementAttribute increment = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            CharTermAttribute attribute = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            int position = -1;
            stream.reset();
            while (stream.incrementToken()) {
                Term term = new Term(field, attribute.toString());
                phrase.add(term, position += increment.getPositionIncrement());
            }
            stream.end();
            stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTokenized(String field, Analyzer analyzer) {
        TokenStream stream = null;
        try {
            stream = analyzer.tokenStream(field, "word1 word2");
            stream.reset();
            if (stream.incrementToken()) {
                boolean bl = stream.incrementToken();
                return bl;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.end();
                    stream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private static boolean hasWildcards(String text) {
        return text != null && (text.indexOf(63) != -1 || text.indexOf(42) != -1);
    }

    @Beta
    public static Query substitute(Query query, Term original, Term replacement) {
        if (query instanceof TermQuery) {
            return Queries.substitute((TermQuery)query, original, replacement);
        }
        if (query instanceof PhraseQuery) {
            return Queries.substitute((PhraseQuery)query, original, replacement);
        }
        if (query instanceof BooleanQuery) {
            return Queries.substitute((BooleanQuery)query, original, replacement);
        }
        if (query instanceof BoostQuery) {
            return Queries.substitute((BoostQuery)query, original, replacement);
        }
        return query;
    }

    @Beta
    public static Query substitute(BooleanQuery query, Term original, Term replacement) {
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        for (BooleanClause clause : query.clauses()) {
            Query qx = Queries.substitute(clause.getQuery(), original, replacement);
            q.add(qx, clause.getOccur());
        }
        return q.build();
    }

    @Beta
    public static Query substitute(BoostQuery query, Term original, Term replacement) {
        return new BoostQuery(Queries.substitute(query.getQuery(), original, replacement), query.getBoost());
    }

    @Beta
    public static TermQuery substitute(TermQuery query, Term original, Term replacement) {
        Term t = query.getTerm();
        if (t.equals((Object)original)) {
            return new TermQuery(replacement);
        }
        return query;
    }

    @Beta
    public static PhraseQuery substitute(PhraseQuery query, Term original, Term replacement) throws IllegalArgumentException {
        boolean doSubstitute = false;
        for (Term t : query.getTerms()) {
            if (!t.equals((Object)original)) continue;
            doSubstitute = true;
        }
        if (doSubstitute) {
            PhraseQuery.Builder q = new PhraseQuery.Builder();
            for (Term t : query.getTerms()) {
                q.add(t.equals((Object)original) ? replacement : t);
            }
            q.setSlop(query.getSlop());
            return q.build();
        }
        return query;
    }
}

